/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.script.core;

import java.util.Properties;
import org.graalvm.polyglot.HostAccess;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.proxy.ProxyExecutable;
import org.luwrain.core.NullCheck;
import org.luwrain.script.ScriptUtils;

public class PropertiesObj {
    protected Properties properties;
    @HostAccess.Export
    public final ProxyExecutable getProperty = this::getPropertyImpl;
    @HostAccess.Export
    public final ProxyExecutable setProperty = this::setPropertyImpl;

    public PropertiesObj(Properties properties) {
        NullCheck.notNull((Object)properties, (String)"properties");
        this.properties = properties;
    }

    private Object getPropertyImpl(Value[] args) {
        if (!ScriptUtils.notNullAndLen(args, 1) || !args[0].isString() || args[0].asString().trim().isEmpty()) {
            throw new IllegalArgumentException("getProperty() takes exactly one non-empty string argument");
        }
        return this.properties.getProperty(args[0].asString().trim());
    }

    private Object setPropertyImpl(Value[] args) {
        if (args == null || args.length != 2) {
            throw new IllegalArgumentException("setProperty() takes two argument");
        }
        if (args[0] == null || args[0].isNull() || args[0].asString().trim().isEmpty()) {
            throw new IllegalArgumentException("setProperty() takes a non-empty string as the first argument");
        }
        if (args[1] != null && !args[1].isNull() && !args[1].isString()) {
            throw new IllegalArgumentException("setProperty() takes null or a string as the second argument");
        }
        this.properties.setProperty(args[0].asString().trim(), args[1] == null || args[1].isNull() ? null : args[1].asString());
        return this;
    }
}

