/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.script.core;

import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.proxy.ProxyObject;
import org.luwrain.core.Log;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;
import org.luwrain.script.ScriptUtils;

final class LogObj
implements ProxyObject {
    final Luwrain luwrain;

    LogObj(Luwrain luwrain) {
        NullCheck.notNull((Object)luwrain, (String)"luwrain");
        this.luwrain = luwrain;
    }

    public Object getMember(String name) {
        if (name == null) {
            return null;
        }
        switch (name) {
            case "debug": {
                return args -> this.log(args, (component, message) -> Log.debug(component, message));
            }
            case "info": {
                return args -> this.log(args, (component, message) -> Log.info(component, message));
            }
            case "warning": {
                return args -> this.log(args, (component, message) -> Log.warning(component, message));
            }
            case "error": {
                return args -> this.log(args, (component, message) -> Log.error(component, message));
            }
            case "fatal": {
                return args -> this.log(args, (component, message) -> Log.fatal(component, message));
            }
        }
        return null;
    }

    public boolean hasMember(String name) {
        switch (name) {
            case "debug": 
            case "info": 
            case "warning": 
            case "error": 
            case "fatal": {
                return true;
            }
        }
        return false;
    }

    public Object getMemberKeys() {
        return new String[]{"debug", "info", "warning", "error", "fatal"};
    }

    public void putMember(String name, Value value) {
    }

    private Object log(Value[] args, Logger logger) {
        NullCheck.notNull((Object)logger, (String)"logger");
        if (!ScriptUtils.notNullAndLen(args, 2)) {
            return null;
        }
        String component = ScriptUtils.asString(args[0]);
        String message = ScriptUtils.asString(args[1]);
        if (component == null || component.trim().isEmpty() || message == null || message.trim().isEmpty()) {
            return null;
        }
        logger.logMessage(component, message);
        return null;
    }

    private static interface Logger {
        public void logMessage(String var1, String var2);
    }
}

