/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.script.core;

import org.graalvm.polyglot.HostAccess;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.proxy.ProxyExecutable;
import org.luwrain.core.Application;
import org.luwrain.core.Area;
import org.luwrain.core.AreaLayout;
import org.luwrain.core.InitResult;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;
import org.luwrain.script.ScriptUtils;
import org.luwrain.script.core.Module;

final class AppImpl
implements Application {
    final Module module;
    final Value construct;
    private Value instance = null;
    private Luwrain luwrain = null;
    private String name = "";
    private AreaLayout layout = null;

    AppImpl(Module module, Value construct) {
        NullCheck.notNull((Object)module, (String)"module");
        NullCheck.notNull((Object)construct, (String)"construct");
        this.module = module;
        this.construct = construct;
    }

    @Override
    public void onAppClose() {
    }

    @Override
    public String getAppName() {
        return this.name != null ? this.name : "";
    }

    @Override
    public AreaLayout getAreaLayout() {
        return this.layout;
    }

    @Override
    public InitResult onLaunchApp(Luwrain luwrain) {
        this.luwrain = luwrain;
        this.instance = this.module.execNewInstance(this.construct, new Object[]{new ControlObj()});
        return new InitResult();
    }

    public final class ControlObj {
        @HostAccess.Export
        public ProxyExecutable setLayout = this::setLayoutImpl;
        @HostAccess.Export
        public ProxyExecutable setName = this::setNameImpl;
        @HostAccess.Export
        public ProxyExecutable close = this::closeImpl;

        private Object setLayoutImpl(Value[] args) {
            Area a = (Area)args[0].asHostObject();
            AppImpl.this.layout = new AreaLayout(a);
            return null;
        }

        private Object setNameImpl(Value[] args) {
            if (!ScriptUtils.notNullAndLen(args, 1) || !args[0].isString()) {
                throw new IllegalArgumentException("App.setName() takes exactly one string argument");
            }
            AppImpl.this.name = args[0].asString();
            return null;
        }

        private Object closeImpl(Value[] args) {
            AppImpl.this.luwrain.closeApp();
            return null;
        }
    }
}

