/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.popups;

import java.io.File;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.luwrain.controls.CommanderArea;
import org.luwrain.controls.DefaultControlContext;
import org.luwrain.controls.ListArea;
import org.luwrain.controls.ListUtils;
import org.luwrain.core.Action;
import org.luwrain.core.AreaQuery;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;
import org.luwrain.core.Popup;
import org.luwrain.core.Suggestions;
import org.luwrain.core.events.ActionEvent;
import org.luwrain.core.events.InputEvent;
import org.luwrain.core.events.SystemEvent;
import org.luwrain.core.queries.UniRefAreaQuery;
import org.luwrain.io.json.CommonSettings;
import org.luwrain.popups.CommanderPopup;
import org.luwrain.popups.DisksPopup;
import org.luwrain.popups.EditListPopup;
import org.luwrain.popups.EditListPopupUtils;
import org.luwrain.popups.FileAcceptance;
import org.luwrain.popups.FilePopup;
import org.luwrain.popups.ListPopup;
import org.luwrain.popups.SimpleEditPopup;
import org.luwrain.popups.StringAcceptance;
import org.luwrain.popups.YesNoPopup;
import org.luwrain.util.FileUtils;

public final class Popups {
    static final String LOG_COMPONENT = "popups";
    public static final Set<Popup.Flags> DEFAULT_POPUP_FLAGS = EnumSet.noneOf(Popup.Flags.class);

    public static String text(Luwrain luwrain, String name, String prefix, String text, final StringAcceptance acceptance, final Luwrain.SpeakableTextType speakableTextType) {
        Objects.requireNonNull(luwrain, "luwrain can't be null");
        NullCheck.notNull((Object)name, (String)"name");
        NullCheck.notNull((Object)prefix, (String)"prefix");
        NullCheck.notNull((Object)text, (String)"text");
        NullCheck.notNull((Object)((Object)speakableTextType), (String)"speakableTextType");
        SimpleEditPopup popup = new SimpleEditPopup(luwrain, name, prefix, text, DEFAULT_POPUP_FLAGS){

            @Override
            protected String getSpeakableText(String prefix, String text) {
                return prefix + this.luwrain.getSpeakableText(text, speakableTextType);
            }

            @Override
            public boolean onOk() {
                return acceptance == null || acceptance.acceptable(this.text);
            }
        };
        luwrain.popup(popup);
        if (popup.closing.cancelled()) {
            return null;
        }
        return popup.text();
    }

    public static String text(Luwrain luwrain, String name, String prefix, String text, StringAcceptance acceptance) {
        Objects.requireNonNull(luwrain, "luwrain can't be null");
        NullCheck.notNull((Object)name, (String)"name");
        NullCheck.notNull((Object)prefix, (String)"prefix");
        NullCheck.notNull((Object)text, (String)"text");
        return Popups.text(luwrain, name, prefix, text, acceptance, Luwrain.SpeakableTextType.PROGRAMMING);
    }

    public static String text(Luwrain luwrain, String name, String prefix, String text) {
        Objects.requireNonNull(luwrain, "luwrain can't be null");
        NullCheck.notNull((Object)name, (String)"name");
        NullCheck.notNull((Object)prefix, (String)"prefix");
        NullCheck.notNull((Object)text, (String)"text");
        return Popups.text(luwrain, name, prefix, text, null);
    }

    public static String textNotEmpty(Luwrain luwrain, String name, String prefix, String text) {
        Objects.requireNonNull(luwrain, "luwrain can't be null");
        NullCheck.notEmpty((Object)name, (String)"name");
        NullCheck.notEmpty((Object)prefix, (String)"prefix");
        NullCheck.notNull((Object)text, (String)"text");
        return Popups.text(luwrain, name, prefix, text, input -> {
            if (input.trim().isEmpty()) {
                luwrain.message("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043d\u0435 \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u043f\u0443\u0441\u0442\u044b\u043c", Luwrain.MessageType.ERROR);
                return false;
            }
            return true;
        });
    }

    public static String editWithHistory(Luwrain luwrain, String name, String prefix, String text, Set<String> history, Set<Popup.Flags> popupFlags) {
        Objects.requireNonNull(luwrain, "luwrain can't be null");
        NullCheck.notNull((Object)name, (String)"name");
        NullCheck.notNull((Object)prefix, (String)"prefix");
        NullCheck.notNull((Object)text, (String)"text");
        NullCheck.notNull(history, (String)"history");
        NullCheck.notNull(popupFlags, (String)"popupFlags");
        EditListPopup popup = new EditListPopup(luwrain, new EditListPopupUtils.FixedModel(history.toArray(new String[history.size()])), name, prefix, text, popupFlags);
        luwrain.popup(popup);
        if (popup.closing.cancelled()) {
            return null;
        }
        history.add(popup.text());
        return popup.text();
    }

    public static String editWithHistory(Luwrain luwrain, String name, String prefix, String text, Set<String> history) {
        Objects.requireNonNull(luwrain, "luwrain can't be null");
        NullCheck.notNull((Object)name, (String)"name");
        NullCheck.notNull((Object)prefix, (String)"prefix");
        NullCheck.notNull((Object)text, (String)"text");
        NullCheck.notNull(history, (String)"history");
        return Popups.editWithHistory(luwrain, name, prefix, text, history, DEFAULT_POPUP_FLAGS);
    }

    public static Object fixedList(Luwrain luwrain, String name, final Object[] items, Set<Popup.Flags> popupFlags) {
        Objects.requireNonNull(luwrain, "luwrain can't be null");
        NullCheck.notNull((Object)name, (String)"name");
        NullCheck.notNullItems((Object[])items, (String)"items");
        NullCheck.notNull(popupFlags, (String)"popupFlags");
        ListArea.Model<Object> model = new ListArea.Model<Object>(){

            @Override
            public int getItemCount() {
                return items.length;
            }

            @Override
            public Object getItem(int index) {
                return index < items.length ? items[index] : null;
            }

            @Override
            public void refresh() {
            }
        };
        ListArea.Params params = new ListArea.Params();
        params.context = new DefaultControlContext(luwrain);
        params.name = name;
        params.model = model;
        params.appearance = new ListUtils.DefaultAppearance(params.context, Suggestions.POPUP_LIST_ITEM);
        params.flags = EnumSet.of(ListArea.Flags.EMPTY_LINE_TOP);
        ListPopup popup = new ListPopup(luwrain, params, popupFlags);
        luwrain.popup(popup);
        if (popup.closing.cancelled()) {
            return null;
        }
        return popup.selected();
    }

    public static Object fixedList(Luwrain luwrain, String name, Object[] items) {
        Objects.requireNonNull(luwrain, "luwrain can't be null");
        NullCheck.notNull((Object)name, (String)"name");
        NullCheck.notNullItems((Object[])items, (String)"items");
        return Popups.fixedList(luwrain, name, items, DEFAULT_POPUP_FLAGS);
    }

    public static File path(Luwrain luwrain, String name, String prefix, File startFrom, FileAcceptance acceptance) {
        Objects.requireNonNull(luwrain, "luwrain can't be null");
        NullCheck.notEmpty((Object)name, (String)"name");
        NullCheck.notEmpty((Object)prefix, (String)"prefix");
        FilePopup popup = new FilePopup(luwrain, name, prefix, acceptance, startFrom != null ? startFrom : luwrain.getFileProperty("luwrain.dir.userhome"), Popups.getUserHome(luwrain), (Set)Popups.loadFilePopupFlags(luwrain), (Set)DEFAULT_POPUP_FLAGS){

            @Override
            public boolean onInputEvent(InputEvent event) {
                NullCheck.notNull((Object)event, (String)"event");
                if (event.isSpecial() && !event.isModified()) {
                    switch (event.getSpecial()) {
                        case INSERT: {
                            if (this.text().isEmpty()) {
                                return false;
                            }
                            File file = FileUtils.ifNotAbsolute(this.luwrain.getFileProperty("luwrain.dir.userhome"), this.text());
                            if (file.exists()) {
                                if (file.isDirectory()) {
                                    this.luwrain.message(this.luwrain.i18n().getStaticStr("DirAlreadyExists"), Luwrain.MessageType.ERROR);
                                } else {
                                    this.luwrain.message(this.luwrain.i18n().getStaticStr("FileAlreadyExists"), Luwrain.MessageType.ERROR);
                                }
                                return true;
                            }
                            if (file.mkdir()) {
                                this.luwrain.message(this.luwrain.i18n().getStaticStr("DirCreated"), Luwrain.MessageType.OK);
                            } else {
                                this.luwrain.message(this.luwrain.i18n().getStaticStr("UnableToCreateDir"), Luwrain.MessageType.ERROR);
                            }
                            return true;
                        }
                    }
                }
                return super.onInputEvent(event);
            }

            @Override
            public boolean onAreaQuery(AreaQuery query) {
                NullCheck.notNull((Object)query, (String)"query");
                switch (query.getQueryCode()) {
                    case 1: {
                        File f = FileUtils.ifNotAbsolute(this.luwrain.getFileProperty("luwrain.dir.userhome"), this.text);
                        if (f.getAbsolutePath().isEmpty()) {
                            return false;
                        }
                        ((UniRefAreaQuery)query).answer("file:" + f.getAbsolutePath());
                        return true;
                    }
                }
                return super.onAreaQuery(query);
            }
        };
        luwrain.popup(popup);
        if (popup.wasCancelled()) {
            return null;
        }
        return popup.result();
    }

    public static File path(Luwrain luwrain, String name, String prefix, FileAcceptance acceptance) {
        Objects.requireNonNull(luwrain, "luwrain can't be null");
        NullCheck.notEmpty((Object)name, (String)"name");
        NullCheck.notNull((Object)prefix, (String)"prefix");
        return Popups.path(luwrain, name, prefix, null, acceptance);
    }

    public static File path(Luwrain luwrain, String name, String prefix) {
        Objects.requireNonNull(luwrain, "luwrain can't be null");
        NullCheck.notEmpty((Object)name, (String)"name");
        NullCheck.notEmpty((Object)prefix, (String)"prefix");
        return Popups.path(luwrain, name, prefix, null);
    }

    public static File existingFile(Luwrain luwrain, String name, File startWith, String[] extensions) {
        Objects.requireNonNull(luwrain, "luwrain can't be null");
        NullCheck.notEmpty((Object)name, (String)"name");
        NullCheck.notNull((Object)startWith, (String)"startWith");
        NullCheck.notNullItems((Object[])extensions, (String)"extensions");
        CommanderArea.Filter<File> filter = Popups.getFilePopupSkipHidden(luwrain) ? CommanderPopup.FILTER_NO_HIDDEN : CommanderPopup.FILTER_ALL;
        final AtomicReference<Object> res = new AtomicReference<Object>(null);
        CommanderPopup popup = new CommanderPopup(luwrain, name, startWith, filter, DEFAULT_POPUP_FLAGS){

            @Override
            public boolean onSystemEvent(SystemEvent event) {
                NullCheck.notNull((Object)event, (String)"event");
                if (event.getType() != SystemEvent.Type.REGULAR) {
                    return super.onSystemEvent(event);
                }
                switch (event.getCode()) {
                    case ACTION: {
                        if (ActionEvent.isAction(event, "select")) {
                            return this.closing.doOk();
                        }
                        return super.onSystemEvent(event);
                    }
                }
                return super.onSystemEvent(event);
            }

            @Override
            public boolean onOk() {
                File file = (File)this.getSelectedEntry();
                if (file == null || !file.isFile()) {
                    return false;
                }
                res.set(file);
                return true;
            }

            @Override
            public Action[] getAreaActions() {
                Action[] a = super.getAreaActions();
                File file = (File)this.getSelectedEntry();
                if (file == null || !file.isFile()) {
                    return a;
                }
                Action[] res2 = Arrays.copyOf(a, a.length + 1);
                res2[res2.length - 1] = new Action("select", "\u0412\u044b\u0431\u0440\u0430\u0442\u044c \u0444\u0430\u0439\u043b");
                return res2;
            }
        };
        luwrain.popup(popup);
        if (popup.isCancelled()) {
            return null;
        }
        return res.get();
    }

    public static File existingFile(Luwrain luwrain, String name) {
        Objects.requireNonNull(luwrain, "luwrain can't be null");
        NullCheck.notEmpty((Object)name, (String)"name");
        return Popups.existingFile(luwrain, name, Popups.getUserHome(luwrain), new String[0]);
    }

    public static File existingDir(Luwrain luwrain, String name, File startWith) {
        Objects.requireNonNull(luwrain, "luwrain can't be null");
        NullCheck.notEmpty((Object)name, (String)"name");
        CommanderArea.Filter<File> filter = Popups.getFilePopupSkipHidden(luwrain) ? CommanderPopup.FILTER_NO_HIDDEN : CommanderPopup.FILTER_ALL;
        final AtomicReference<Object> res = new AtomicReference<Object>(null);
        CommanderPopup popup = new CommanderPopup(luwrain, name, startWith, filter, DEFAULT_POPUP_FLAGS){

            @Override
            public boolean onSystemEvent(SystemEvent event) {
                NullCheck.notNull((Object)event, (String)"event");
                if (event.getType() != SystemEvent.Type.REGULAR) {
                    return super.onSystemEvent(event);
                }
                switch (event.getCode()) {
                    case ACTION: {
                        if (ActionEvent.isAction(event, "select")) {
                            return this.closing.doOk();
                        }
                        return super.onSystemEvent(event);
                    }
                }
                return super.onSystemEvent(event);
            }

            @Override
            public boolean onOk() {
                File file = (File)this.opened();
                if (file == null) {
                    return false;
                }
                res.set(file);
                return true;
            }

            @Override
            public Action[] getAreaActions() {
                Action[] a = super.getAreaActions();
                File file = (File)this.opened();
                if (file == null) {
                    return a;
                }
                Action[] res2 = Arrays.copyOf(a, a.length + 1);
                res2[res2.length - 1] = new Action("select", "\u0412\u044b\u0431\u0440\u0430\u0442\u044c \u0442\u0435\u043a\u0443\u0449\u0438\u0439 \u043a\u0430\u0442\u0430\u043b\u043e\u0433");
                return res2;
            }
        };
        luwrain.popup(popup);
        if (popup.isCancelled()) {
            return null;
        }
        return res.get();
    }

    public static File existingDir(Luwrain luwrain, String name) {
        Objects.requireNonNull(luwrain, "luwrain can't be null");
        NullCheck.notEmpty((Object)name, (String)"name");
        return Popups.existingDir(luwrain, name, Popups.getUserHome(luwrain));
    }

    static boolean mkdir(Luwrain luwrain, File createIn) {
        Objects.requireNonNull(luwrain, "luwrain can't be null");
        NullCheck.notNull((Object)createIn, (String)"createIn");
        FilePopup newDirPopup = new FilePopup(luwrain, "\u041d\u043e\u0432\u044b\u0439 \u043a\u0430\u0442\u0430\u043b\u043e\u0433", "\u0418\u043c\u044f \u043d\u043e\u0432\u043e\u0433\u043e \u043a\u0430\u0442\u0430\u043b\u043e\u0433\u0430:", null, new File(""), createIn, (Set)Popups.loadFilePopupFlags(luwrain), (Set)DEFAULT_POPUP_FLAGS){

            @Override
            public boolean onOk() {
                File file = this.result();
                if (file == null) {
                    return false;
                }
                if (file.mkdir()) {
                    return true;
                }
                this.luwrain.message(this.luwrain.i18n().getStaticStr("UnableToCreateDir"), Luwrain.MessageType.ERROR);
                return false;
            }
        };
        luwrain.popup(newDirPopup);
        return true;
    }

    public static File disks(Luwrain luwrain, String name) {
        Objects.requireNonNull(luwrain, "luwrain can't be null");
        NullCheck.notNull((Object)name, (String)"name");
        DisksPopup popup = new DisksPopup(luwrain, name, DEFAULT_POPUP_FLAGS);
        luwrain.popup(popup);
        if (popup.wasCancelled()) {
            return null;
        }
        return popup.result();
    }

    public static String fixedEditList(Luwrain luwrain, String name, String prefix, String text, String[] items) {
        Objects.requireNonNull(luwrain, "luwrain can't be null");
        NullCheck.notNull((Object)name, (String)"name");
        NullCheck.notNull((Object)prefix, (String)"prefix");
        NullCheck.notNull((Object)text, (String)"text");
        NullCheck.notNullItems((Object[])items, (String)"items");
        EditListPopup popup = new EditListPopup(luwrain, new EditListPopupUtils.FixedModel(items), name, prefix, text, DEFAULT_POPUP_FLAGS);
        luwrain.popup(popup);
        if (popup.closing.cancelled()) {
            return null;
        }
        return popup.text();
    }

    public static boolean confirmDefaultYes(Luwrain luwrain, String name, String text) {
        Objects.requireNonNull(luwrain, "luwrain can't be null");
        NullCheck.notNull((Object)name, (String)"name");
        NullCheck.notNull((Object)text, (String)"text");
        YesNoPopup popup = new YesNoPopup(luwrain, name, text, true, DEFAULT_POPUP_FLAGS);
        luwrain.popup(popup);
        if (popup.closing.cancelled()) {
            return false;
        }
        return popup.result();
    }

    public static boolean confirmDefaultNo(Luwrain luwrain, String name, String text) {
        Objects.requireNonNull(luwrain, "luwrain can't be null");
        NullCheck.notNull((Object)name, (String)"name");
        NullCheck.notNull((Object)text, (String)"text");
        YesNoPopup popup = new YesNoPopup(luwrain, name, text, false, DEFAULT_POPUP_FLAGS);
        luwrain.popup(popup);
        if (popup.closing.cancelled()) {
            return false;
        }
        return popup.result();
    }

    private static File getUserHome(Luwrain luwrain) {
        Objects.requireNonNull(luwrain, "luwrain can't be null");
        return luwrain.getFileProperty("luwrain.dir.userhome");
    }

    public static Set<FilePopup.Flags> loadFilePopupFlags(Luwrain luwrain) {
        Objects.requireNonNull(luwrain, "luwrain can't be null");
        if (Popups.getFilePopupSkipHidden(luwrain)) {
            return EnumSet.of(FilePopup.Flags.SKIP_HIDDEN);
        }
        return EnumSet.noneOf(FilePopup.Flags.class);
    }

    static boolean getFilePopupSkipHidden(Luwrain luwrain) {
        Objects.requireNonNull(luwrain, "luwrain can't be null");
        CommonSettings conf = luwrain.loadConf(CommonSettings.class);
        if (conf == null) {
            return false;
        }
        return conf.isFilePopupSkipHidden();
    }
}

