/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.popups;

import java.util.EnumSet;
import java.util.Set;
import org.luwrain.core.DefaultEventResponse;
import org.luwrain.core.Hint;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;
import org.luwrain.core.Popup;
import org.luwrain.core.events.InputEvent;
import org.luwrain.popups.EditListPopupUtils;
import org.luwrain.popups.SimpleEditPopup;

public class EditListPopup
extends SimpleEditPopup {
    private static final int MAX_ALTERNATIVES_TO_SAY = 100;
    protected final Model model;
    protected final Appearance appearance;

    public EditListPopup(Luwrain luwrain, Model model, Appearance appearance, String name, String prefix, String text, Set<Popup.Flags> popupFlags) {
        super(luwrain, name, prefix, text, popupFlags);
        NullCheck.notNull((Object)model, (String)"model");
        NullCheck.notNull((Object)appearance, (String)"appearance");
        this.model = model;
        this.appearance = appearance;
    }

    public EditListPopup(Luwrain luwrain, Model model, String name, String prefix, String text, Set<Popup.Flags> popupFlags) {
        this(luwrain, model, new EditListPopupUtils.DefaultAppearance(luwrain), name, prefix, text, popupFlags);
    }

    @Override
    public boolean onInputEvent(InputEvent event) {
        NullCheck.notNull((Object)event, (String)"event");
        if (event.isSpecial() && !event.isModified()) {
            switch (event.getSpecial()) {
                case TAB: {
                    this.onTab();
                    return true;
                }
                case ARROW_DOWN: {
                    return this.onMoveDown(false);
                }
                case ARROW_UP: {
                    return this.onMoveUp(false);
                }
                case ALTERNATIVE_ARROW_DOWN: {
                    return this.onMoveDown(true);
                }
                case ALTERNATIVE_ARROW_UP: {
                    return this.onMoveUp(true);
                }
            }
            return super.onInputEvent(event);
        }
        return super.onInputEvent(event);
    }

    protected void onTab() {
        String completion;
        String text = this.getTextBeforeHotPoint();
        String after = this.getTextAfterHotPoint();
        if (!text.isEmpty() && (completion = this.model.getCompletion(text)) != null && !completion.isEmpty()) {
            this.luwrain.speak(this.getSpeakableText("", completion));
            this.setText(text + completion, after);
            return;
        }
        String[] alternatives = this.model.getAlternatives(text);
        if (alternatives == null || alternatives.length == 0) {
            return;
        }
        int count = alternatives.length <= 100 ? alternatives.length : 100;
        Object res = "";
        for (int i = 0; i < count; ++i) {
            res = (String)res + alternatives[i] + " ";
        }
        this.luwrain.speak((String)res);
    }

    protected boolean onMoveUp(boolean briefAnnouncement) {
        Item item = this.model.getListPopupPreviousItem(this.getTextBeforeHotPoint());
        if (item == null) {
            this.luwrain.setEventResponse(DefaultEventResponse.hint(Hint.NO_ITEMS_ABOVE));
            return true;
        }
        this.appearance.announceItem(item, briefAnnouncement ? EnumSet.of(Appearance.Flags.BRIEF) : EnumSet.noneOf(Appearance.Flags.class));
        this.setText(item.getValue(), "");
        return true;
    }

    protected boolean onMoveDown(boolean briefAnnouncement) {
        Item item = this.model.getListPopupNextItem(this.getTextBeforeHotPoint());
        if (item == null) {
            this.luwrain.setEventResponse(DefaultEventResponse.hint(Hint.NO_ITEMS_BELOW));
            return true;
        }
        this.appearance.announceItem(item, briefAnnouncement ? EnumSet.of(Appearance.Flags.BRIEF) : EnumSet.noneOf(Appearance.Flags.class));
        this.setText(item.getValue(), "");
        return true;
    }

    @Override
    protected String getSpeakableText(String prefix, String text) {
        NullCheck.notNull((Object)prefix, (String)"prefix");
        NullCheck.notNull((Object)text, (String)"text");
        return this.appearance.getSpeakableText(prefix, text);
    }

    public static interface Model {
        public String getCompletion(String var1);

        public String[] getAlternatives(String var1);

        public Item getListPopupPreviousItem(String var1);

        public Item getListPopupNextItem(String var1);
    }

    public static interface Appearance {
        public void announceItem(Item var1, Set<Flags> var2);

        public String getSpeakableText(String var1, String var2);

        public static enum Flags {
            BRIEF;

        }
    }

    public static interface Item
    extends Comparable {
        public String getValue();

        public String getAnnouncement();
    }
}

