/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.io.json;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;
import org.luwrain.core.UniRefInfo;

public class DesktopItem {
    public static final String TYPE_UNIREF = "uniref";
    public static final Type LIST_TYPE = new TypeToken<List<DesktopItem>>(){}.getType();
    private static Gson gson = null;
    @SerializedName(value="type")
    private String type = null;
    @SerializedName(value="value")
    private String value = null;
    private transient UniRefInfo uniRefInfo = null;

    public DesktopItem() {
    }

    public DesktopItem(String type, String value) {
        this.type = type;
        this.value = value;
    }

    public DesktopItem(UniRefInfo uniRefInfo) {
        NullCheck.notNull((Object)uniRefInfo, (String)"uniRefInfo");
        this.type = TYPE_UNIREF;
        this.value = uniRefInfo.getValue();
        this.uniRefInfo = uniRefInfo;
    }

    public UniRefInfo getUniRefInfo(Luwrain luwrain) {
        NullCheck.notNull((Object)luwrain, (String)"luwrain");
        if (this.uniRefInfo != null) {
            return this.uniRefInfo;
        }
        this.uniRefInfo = luwrain.getUniRefInfo(this.getValueNotNull());
        return this.uniRefInfo;
    }

    public String getType() {
        return this.type;
    }

    public String getTypeNotNull() {
        return this.type != null ? this.type : "";
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getValue() {
        return this.value;
    }

    public String getValueNotNull() {
        return this.value != null ? this.value : "";
    }

    public void setValue(String value) {
        this.value = value;
    }

    public static String toJson(DesktopItem[] items) {
        if (gson == null) {
            gson = new Gson();
        }
        return gson.toJson((Object)items);
    }

    public static DesktopItem[] fromJson(String s) {
        List res;
        NullCheck.notNull((Object)s, (String)"s");
        if (gson == null) {
            gson = new Gson();
        }
        return (res = (List)new Gson().fromJson(s, LIST_TYPE)) != null ? res.toArray(new DesktopItem[res.size()]) : new DesktopItem[]{};
    }
}

