/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.io.json;

import java.util.ArrayList;
import java.util.List;
import org.luwrain.core.Starter;
import org.luwrain.io.json.MainMenuItem;

public final class CommonSettings {
    String desktopTitle;
    String desktopEscapeCommand;
    String windowTitle;
    String timeZone;
    boolean hintsSounds;
    boolean hintsText;
    boolean hintsSoundsSpace;
    boolean filePopupSkipHidden;
    List<MainMenuItem> mainMenuItems;

    public static CommonSettings createInitial(List<Starter> starters) {
        CommonSettings s = new CommonSettings();
        s.setHintsSounds(true);
        s.setHintsText(true);
        s.setHintsSoundsSpace(true);
        s.setFilePopupSkipHidden(true);
        s.setDesktopTitle("LUWRAIN");
        s.setWindowTitle("LUWRAIN");
        s.setDesktopEscapeCommand("quit");
        ArrayList<MainMenuItem> mainMenu = new ArrayList<MainMenuItem>();
        for (Starter st : starters) {
            mainMenu.add(new MainMenuItem("uri", st.getUri().toString()));
        }
        s.setMainMenuItems(mainMenu);
        return s;
    }

    public String getDesktopTitle() {
        return this.desktopTitle;
    }

    public String getDesktopEscapeCommand() {
        return this.desktopEscapeCommand;
    }

    public String getWindowTitle() {
        return this.windowTitle;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public boolean isHintsSounds() {
        return this.hintsSounds;
    }

    public boolean isHintsText() {
        return this.hintsText;
    }

    public boolean isHintsSoundsSpace() {
        return this.hintsSoundsSpace;
    }

    public boolean isFilePopupSkipHidden() {
        return this.filePopupSkipHidden;
    }

    public List<MainMenuItem> getMainMenuItems() {
        return this.mainMenuItems;
    }

    public void setDesktopTitle(String desktopTitle) {
        this.desktopTitle = desktopTitle;
    }

    public void setDesktopEscapeCommand(String desktopEscapeCommand) {
        this.desktopEscapeCommand = desktopEscapeCommand;
    }

    public void setWindowTitle(String windowTitle) {
        this.windowTitle = windowTitle;
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    public void setHintsSounds(boolean hintsSounds) {
        this.hintsSounds = hintsSounds;
    }

    public void setHintsText(boolean hintsText) {
        this.hintsText = hintsText;
    }

    public void setHintsSoundsSpace(boolean hintsSoundsSpace) {
        this.hintsSoundsSpace = hintsSoundsSpace;
    }

    public void setFilePopupSkipHidden(boolean filePopupSkipHidden) {
        this.filePopupSkipHidden = filePopupSkipHidden;
    }

    public void setMainMenuItems(List<MainMenuItem> mainMenuItems) {
        this.mainMenuItems = mainMenuItems;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CommonSettings)) {
            return false;
        }
        CommonSettings other = (CommonSettings)o;
        if (this.isHintsSounds() != other.isHintsSounds()) {
            return false;
        }
        if (this.isHintsText() != other.isHintsText()) {
            return false;
        }
        if (this.isHintsSoundsSpace() != other.isHintsSoundsSpace()) {
            return false;
        }
        if (this.isFilePopupSkipHidden() != other.isFilePopupSkipHidden()) {
            return false;
        }
        String this$desktopTitle = this.getDesktopTitle();
        String other$desktopTitle = other.getDesktopTitle();
        if (this$desktopTitle == null ? other$desktopTitle != null : !this$desktopTitle.equals(other$desktopTitle)) {
            return false;
        }
        String this$desktopEscapeCommand = this.getDesktopEscapeCommand();
        String other$desktopEscapeCommand = other.getDesktopEscapeCommand();
        if (this$desktopEscapeCommand == null ? other$desktopEscapeCommand != null : !this$desktopEscapeCommand.equals(other$desktopEscapeCommand)) {
            return false;
        }
        String this$windowTitle = this.getWindowTitle();
        String other$windowTitle = other.getWindowTitle();
        if (this$windowTitle == null ? other$windowTitle != null : !this$windowTitle.equals(other$windowTitle)) {
            return false;
        }
        String this$timeZone = this.getTimeZone();
        String other$timeZone = other.getTimeZone();
        if (this$timeZone == null ? other$timeZone != null : !this$timeZone.equals(other$timeZone)) {
            return false;
        }
        List<MainMenuItem> this$mainMenuItems = this.getMainMenuItems();
        List<MainMenuItem> other$mainMenuItems = other.getMainMenuItems();
        return !(this$mainMenuItems == null ? other$mainMenuItems != null : !((Object)this$mainMenuItems).equals(other$mainMenuItems));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isHintsSounds() ? 79 : 97);
        result = result * 59 + (this.isHintsText() ? 79 : 97);
        result = result * 59 + (this.isHintsSoundsSpace() ? 79 : 97);
        result = result * 59 + (this.isFilePopupSkipHidden() ? 79 : 97);
        String $desktopTitle = this.getDesktopTitle();
        result = result * 59 + ($desktopTitle == null ? 43 : $desktopTitle.hashCode());
        String $desktopEscapeCommand = this.getDesktopEscapeCommand();
        result = result * 59 + ($desktopEscapeCommand == null ? 43 : $desktopEscapeCommand.hashCode());
        String $windowTitle = this.getWindowTitle();
        result = result * 59 + ($windowTitle == null ? 43 : $windowTitle.hashCode());
        String $timeZone = this.getTimeZone();
        result = result * 59 + ($timeZone == null ? 43 : $timeZone.hashCode());
        List<MainMenuItem> $mainMenuItems = this.getMainMenuItems();
        result = result * 59 + ($mainMenuItems == null ? 43 : ((Object)$mainMenuItems).hashCode());
        return result;
    }

    public String toString() {
        return "CommonSettings(desktopTitle=" + this.getDesktopTitle() + ", desktopEscapeCommand=" + this.getDesktopEscapeCommand() + ", windowTitle=" + this.getWindowTitle() + ", timeZone=" + this.getTimeZone() + ", hintsSounds=" + this.isHintsSounds() + ", hintsText=" + this.isHintsText() + ", hintsSoundsSpace=" + this.isHintsSoundsSpace() + ", filePopupSkipHidden=" + this.isFilePopupSkipHidden() + ", mainMenuItems=" + String.valueOf(this.getMainMenuItems()) + ")";
    }

    public CommonSettings() {
    }

    public CommonSettings(String desktopTitle, String desktopEscapeCommand, String windowTitle, String timeZone, boolean hintsSounds, boolean hintsText, boolean hintsSoundsSpace, boolean filePopupSkipHidden, List<MainMenuItem> mainMenuItems) {
        this.desktopTitle = desktopTitle;
        this.desktopEscapeCommand = desktopEscapeCommand;
        this.windowTitle = windowTitle;
        this.timeZone = timeZone;
        this.hintsSounds = hintsSounds;
        this.hintsText = hintsText;
        this.hintsSoundsSpace = hintsSoundsSpace;
        this.filePopupSkipHidden = filePopupSkipHidden;
        this.mainMenuItems = mainMenuItems;
    }
}

