/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.i18n;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Objects;
import java.util.Properties;

public final class ResourceStringsObj
implements InvocationHandler {
    private static final String CHARSET = "UTF-8";
    private final ClassLoader classLoader;
    private final Properties props;

    public ResourceStringsObj(ClassLoader classLoader, Class cl, String resName) throws IOException {
        Objects.requireNonNull(resName, "resName can't be null");
        if (resName.isEmpty()) {
            throw new IllegalArgumentException("resName can't be empty");
        }
        this.classLoader = Objects.requireNonNull(classLoader, "classLoader can't be null");
        this.props = new Properties();
        try (BufferedReader r = new BufferedReader(new InputStreamReader(cl.getResourceAsStream(resName), CHARSET));){
            this.props.load(r);
        }
    }

    public <T> T create(String langName, Class cl) {
        Objects.requireNonNull(langName, "langName can't be null");
        Objects.requireNonNull(cl, "cl can't be null");
        if (langName.isEmpty()) {
            throw new IllegalArgumentException("langName can't be empty");
        }
        return (T)Proxy.newProxyInstance(this.classLoader, new Class[]{cl}, (InvocationHandler)this);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String value;
        Object name = method.getName();
        if (((String)name).length() > 1 && Character.isLowerCase(((String)name).charAt(0))) {
            name = Character.toUpperCase(((String)name).charAt(0)) + ((String)name).substring(1);
        }
        if ((value = this.props.getProperty((String)name)) == null) {
            if (args != null) {
                Object[] a = new Object[args.length];
                for (int i = 0; i < args.length; ++i) {
                    a[i] = args[i] == null ? null : (args[i] instanceof String || args[i] instanceof Number || args[i] instanceof Boolean ? args[i] : args[i].toString());
                }
            } else {
                Object[] a = new Object[]{};
            }
            return "#No value: " + (String)name + "#";
        }
        if (value.indexOf("$") < 0) {
            return value.trim();
        }
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < value.length(); ++i) {
            if (value.charAt(i) != '$' || i + 1 >= value.length() || value.charAt(i + 1) < '0' || value.charAt(i + 1) > '9') {
                b.append(value.charAt(i));
                continue;
            }
            b.append(args[value.charAt(++i) - 49].toString());
        }
        return new String(b).toString();
    }
}

