/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.core.util;

import java.util.Locale;
import org.luwrain.core.CmdLine;
import org.luwrain.core.Log;
import org.luwrain.core.NullCheck;

public final class Checks {
    private static final String LOG_COMPONENT = "Checks";
    private static final String DEFAULT_LANG = "en";
    private static final String ENV_LANG = "LUWRAIN_LANG";
    public static final String CMDARG_LANG = "--lang=";

    public static String detectLang(CmdLine cmdLine) {
        String lang;
        NullCheck.notNull((Object)cmdLine, (String)"cmdLine");
        String cmdLineArg = cmdLine.getFirstArg(CMDARG_LANG);
        if (cmdLineArg != null) {
            switch (cmdLineArg.trim().toLowerCase()) {
                case "ru": 
                case "en": 
                case "ro": {
                    return cmdLineArg.trim().toLowerCase();
                }
            }
            Log.error(LOG_COMPONENT, "unknown language '" + cmdLineArg + "' in the command line options");
            return "";
        }
        if (System.getenv().containsKey(ENV_LANG) && !System.getenv().get(ENV_LANG).trim().isEmpty()) {
            switch (lang = System.getenv().get(ENV_LANG).toLowerCase().trim()) {
                case "en": 
                case "ru": 
                case "ro": {
                    return lang;
                }
            }
            Log.warning(LOG_COMPONENT, "the environment variable LUWRAIN_LANG contains an improper value '" + lang + "', ignoring it");
        }
        switch (lang = Locale.getDefault().getISO3Language().trim().toLowerCase()) {
            case "eng": {
                return DEFAULT_LANG;
            }
            case "rus": {
                return "ru";
            }
        }
        Log.warning(LOG_COMPONENT, "locale detects the UI language as " + lang + ", but it isn't supported, using the default language en");
        return DEFAULT_LANG;
    }
}

