/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.core.speech;

import org.luwrain.core.ExtensionsManager;
import org.luwrain.core.NullCheck;
import org.luwrain.core.speech.SpeakingHook;

public class SpeakingText {
    private ExtensionsManager extensions;

    public SpeakingText(ExtensionsManager extensions) {
        NullCheck.notNull((Object)extensions, (String)"extensions");
        this.extensions = extensions;
    }

    public String processRegular(String text) {
        NullCheck.notNull((Object)text, (String)"text");
        SpeakingHook hook = new SpeakingHook(text);
        this.extensions.runHooks("luwrain.speech.text.regular", hook);
        return hook.getText().replaceAll("\\h", " ");
    }

    public String processEventResponse(String text) {
        NullCheck.notNull((Object)text, (String)"text");
        return this.processRegular(text);
    }
}

