/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.core.sound;

import java.net.URL;
import org.luwrain.core.ContentTypes;
import org.luwrain.core.ExtObjects;
import org.luwrain.core.Log;
import org.luwrain.core.MediaResourcePlayer;
import org.luwrain.core.NullCheck;

final class BkgPlayer {
    private static final String LOG_COMPONENT = "core";
    private final ExtObjects extObjs;
    private final String url;
    private MediaResourcePlayer.Instance instance = null;

    BkgPlayer(ExtObjects extObjs, String url) {
        NullCheck.notNull((Object)extObjs, (String)"extObjs");
        NullCheck.notEmpty((Object)url, (String)"url");
        this.extObjs = extObjs;
        this.url = url;
    }

    void start() {
        MediaResourcePlayer player = null;
        for (MediaResourcePlayer p : this.extObjs.getMediaResourcePlayers()) {
            if (!p.getSupportedMimeType().equals(ContentTypes.SOUND_MP3_DEFAULT)) continue;
            player = p;
            break;
        }
        if (player == null) {
            Log.error(LOG_COMPONENT, "unable to find a media resource player for " + this.url.toString());
            return;
        }
        this.instance = player.newMediaResourcePlayer(new MediaResourcePlayer.Listener(){

            @Override
            public void onPlayerTime(MediaResourcePlayer.Instance instance, long msec) {
            }

            @Override
            public void onPlayerFinish(MediaResourcePlayer.Instance instance) {
                BkgPlayer.this.play();
            }

            @Override
            public void onPlayerError(Exception e) {
                Log.error(BkgPlayer.LOG_COMPONENT, "media resource player error for " + BkgPlayer.this.url.toString() + ": " + e.getClass().getName() + ":" + e.getMessage());
            }
        });
        this.play();
    }

    synchronized void stopPlaying() {
        if (this.instance == null) {
            return;
        }
        this.instance.stop();
        this.instance = null;
    }

    private synchronized void play() {
        if (this.instance == null) {
            return;
        }
        try {
            this.instance.stop();
            this.instance.play(new URL(this.url), new MediaResourcePlayer.Params());
        }
        catch (Throwable e) {
            Log.error(LOG_COMPONENT, "unable to start playing of " + this.url.toString() + ": " + e.getClass().getName() + ":" + e.getMessage());
            e.printStackTrace();
        }
    }
}

