/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.core.events.resp;

import java.util.ArrayList;
import org.luwrain.core.EventResponse;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;
import org.luwrain.core.Sounds;
import org.luwrain.core.Suggestions;
import org.luwrain.core.events.resp.Base;
import org.luwrain.io.json.CommonSettings;

public class TreeItemResponse
implements EventResponse {
    protected final Type type;
    protected final Sounds sound;
    protected final String text;
    protected final int level;
    protected final Suggestions suggestion;

    public TreeItemResponse(Type type, Sounds sound, String text, int level, Suggestions suggestion) {
        NullCheck.notNull((Object)((Object)type), (String)"type");
        NullCheck.notNull((Object)text, (String)"text");
        this.type = type;
        this.sound = sound;
        this.text = text;
        this.level = level;
        if (level < 1) {
            throw new IllegalArgumentException("level (" + level + ") may not be less than one");
        }
        this.suggestion = suggestion;
    }

    public TreeItemResponse(Type type, String text, int level, Suggestions suggestion) {
        this(type, null, text, level, suggestion);
    }

    public TreeItemResponse(Type type, String text, int level) {
        this(type, null, text, level, null);
    }

    @Override
    public void announce(Luwrain luwrain, EventResponse.Speech speech, CommonSettings sett) {
        String suggestionText;
        NullCheck.notNull((Object)luwrain, (String)"luwrain");
        NullCheck.notNull((Object)speech, (String)"speech");
        if (this.sound != null) {
            luwrain.playSound(this.sound);
        } else {
            switch (this.type) {
                case COLLAPSED: {
                    luwrain.playSound(Sounds.COLLAPSED);
                    break;
                }
                case EXPANDED: {
                    luwrain.playSound(Sounds.EXPANDED);
                    break;
                }
                case LEAF: {
                    luwrain.playSound(Sounds.LIST_ITEM);
                }
            }
        }
        ArrayList<Object> parts = new ArrayList<Object>();
        parts.add(this.text);
        switch (this.type) {
            case EXPANDED: {
                parts.add(luwrain.i18n().getStaticStr("TreeExpanded"));
                break;
            }
            case COLLAPSED: {
                parts.add(luwrain.i18n().getStaticStr("TreeCollapsed"));
            }
        }
        if (this.level > 1) {
            parts.add(luwrain.i18n().getStaticStr("TreeLevel") + String.valueOf(this.level));
        }
        if (this.suggestion != null && (suggestionText = Base.getSuggestionText(this.suggestion, luwrain.i18n())) != null) {
            parts.add(suggestionText);
        }
        speech.speak(parts.toArray(new String[parts.size()]));
    }

    public static enum Type {
        LEAF,
        EXPANDED,
        COLLAPSED;

    }
}

