/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.core;

import java.io.File;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;
import org.luwrain.core.UniRefInfo;
import org.luwrain.core.UniRefProc;

public final class UniRefProcs {
    public static final String TYPE_ALIAS = "alias";
    public static final String TYPE_COMMAND = "command";
    public static final String TYPE_EMPTY = "empty";
    public static final String TYPE_FILE = "file";
    public static final String TYPE_SECTION = "section";
    public static final String TYPE_STATIC = "static";
    public static final String TYPE_URL = "url";

    static UniRefProc[] createStandardUniRefProcs(final Luwrain luwrain) {
        NullCheck.notNull((Object)luwrain, (String)"luwrain");
        return new UniRefProc[]{new UniRefProc(){
            private static final String PREFIX = "file:";

            @Override
            public String getUniRefType() {
                return UniRefProcs.TYPE_FILE;
            }

            @Override
            public UniRefInfo getUniRefInfo(String uniRef) {
                NullCheck.notEmpty((Object)uniRef, (String)"uniRef");
                if (!uniRef.startsWith(PREFIX)) {
                    return null;
                }
                File file = new File(uniRef.substring(PREFIX.length()));
                return new UniRefInfo(uniRef, UniRefProcs.TYPE_FILE, file.getAbsolutePath(), file.getName());
            }

            @Override
            public boolean openUniRef(String uniRef, Luwrain luwrain) {
                NullCheck.notEmpty((Object)uniRef, (String)"uniRef");
                NullCheck.notNull((Object)luwrain, (String)"luwrain");
                if (!uniRef.startsWith(PREFIX)) {
                    return false;
                }
                luwrain.openFile(uniRef.substring(PREFIX.length()));
                return true;
            }
        }, new UniRefProc(){
            private static final String PREFIX = "url:";

            @Override
            public String getUniRefType() {
                return UniRefProcs.TYPE_URL;
            }

            @Override
            public UniRefInfo getUniRefInfo(String uniRef) {
                NullCheck.notEmpty((Object)uniRef, (String)"uniRef");
                if (!uniRef.startsWith(PREFIX)) {
                    return null;
                }
                return new UniRefInfo(uniRef, UniRefProcs.TYPE_URL, uniRef.substring(PREFIX.length()), uniRef.substring(PREFIX.length()));
            }

            @Override
            public boolean openUniRef(String uniRef, Luwrain luwrain) {
                NullCheck.notEmpty((Object)uniRef, (String)"uniRef");
                NullCheck.notNull((Object)luwrain, (String)"luwrain");
                if (!uniRef.startsWith(PREFIX)) {
                    return false;
                }
                luwrain.launchApp("reader", new String[]{uniRef.substring(PREFIX.length())});
                return true;
            }
        }, new UniRefProc(){
            private static final String PREFIX = "static:";

            @Override
            public String getUniRefType() {
                return UniRefProcs.TYPE_STATIC;
            }

            @Override
            public UniRefInfo getUniRefInfo(String uniRef) {
                NullCheck.notEmpty((Object)uniRef, (String)"uniRef");
                if (!uniRef.startsWith(PREFIX)) {
                    return null;
                }
                return new UniRefInfo(uniRef, UniRefProcs.TYPE_STATIC, "", uniRef.substring(PREFIX.length()));
            }

            @Override
            public boolean openUniRef(String uniRef, Luwrain luwrain) {
                NullCheck.notEmpty((Object)uniRef, (String)"uniRef");
                return false;
            }
        }, new UniRefProc(){
            private static final String PREFIX = "section:";

            @Override
            public String getUniRefType() {
                return UniRefProcs.TYPE_SECTION;
            }

            @Override
            public UniRefInfo getUniRefInfo(String uniRef) {
                NullCheck.notEmpty((Object)uniRef, (String)"uniRef");
                if (!uniRef.startsWith(PREFIX)) {
                    return null;
                }
                return new UniRefInfo(uniRef, UniRefProcs.TYPE_SECTION, "", uniRef.substring(PREFIX.length()));
            }

            @Override
            public boolean openUniRef(String uniRef, Luwrain luwrain) {
                NullCheck.notEmpty((Object)uniRef, (String)"uniRef");
                return false;
            }
        }, new UniRefProc(){
            private static final String PREFIX = "empty:";

            @Override
            public String getUniRefType() {
                return UniRefProcs.TYPE_EMPTY;
            }

            @Override
            public UniRefInfo getUniRefInfo(String uniRef) {
                NullCheck.notEmpty((Object)uniRef, (String)"uniRef");
                if (!uniRef.startsWith(PREFIX)) {
                    return null;
                }
                return new UniRefInfo(uniRef, UniRefProcs.TYPE_EMPTY, "", "");
            }

            @Override
            public boolean openUniRef(String uniRef, Luwrain luwrain) {
                NullCheck.notEmpty((Object)uniRef, (String)"uniRef");
                return false;
            }
        }, new UniRefProc(){

            @Override
            public String getUniRefType() {
                return UniRefProcs.TYPE_COMMAND;
            }

            @Override
            public UniRefInfo getUniRefInfo(String uniRef) {
                NullCheck.notNull((Object)uniRef, (String)"uniRef");
                String prefix = "command:";
                if (!uniRef.startsWith("command:")) {
                    return null;
                }
                String command = uniRef.substring("command:".length());
                return new UniRefInfo(uniRef, UniRefProcs.TYPE_COMMAND, command, luwrain.i18n().getCommandTitle(command));
            }

            @Override
            public boolean openUniRef(String uniRef, Luwrain luwrain2) {
                if (uniRef == null || uniRef.isEmpty()) {
                    return false;
                }
                if (!uniRef.startsWith("command:")) {
                    return false;
                }
                luwrain2.runCommand(uniRef.substring(8));
                return true;
            }
        }, new UniRefProc(){

            @Override
            public String getUniRefType() {
                return UniRefProcs.TYPE_ALIAS;
            }

            @Override
            public UniRefInfo getUniRefInfo(String uniRef) {
                NullCheck.notNull((Object)uniRef, (String)"uniRef");
                String prefix = "alias:";
                if (!uniRef.startsWith("alias:")) {
                    return null;
                }
                String body = uniRef.substring("alias:".length());
                if (body.isEmpty()) {
                    return null;
                }
                int delim = this.findDelim(body);
                if (delim < 0) {
                    return null;
                }
                return new UniRefInfo(uniRef, UniRefProcs.TYPE_ALIAS, body.substring(delim + 1), body.substring(0, delim).replaceAll("\\\\:", ":"));
            }

            @Override
            public boolean openUniRef(String uniRef, Luwrain luwrain) {
                NullCheck.notNull((Object)uniRef, (String)"uniRef");
                NullCheck.notNull((Object)luwrain, (String)"luwrain");
                String prefix = "alias:";
                if (!uniRef.startsWith("alias:")) {
                    return false;
                }
                String body = uniRef.substring("alias:".length());
                if (body.isEmpty()) {
                    return false;
                }
                int delim = this.findDelim(body);
                if (delim < 0 || delim + 1 >= body.length()) {
                    return false;
                }
                String newUniRef = body.substring(delim + 1);
                if (!newUniRef.isEmpty()) {
                    return luwrain.openUniRef(newUniRef);
                }
                return false;
            }

            private int findDelim(String str) {
                int delim;
                NullCheck.notNull((Object)str, (String)"str");
                for (delim = 0; delim < str.length() && (str.charAt(delim) != ':' || delim > 0 && str.charAt(delim - 1) == '\\'); ++delim) {
                }
                return delim < str.length() ? delim : -1;
            }
        }};
    }
}

