/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.core;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;
import org.luwrain.core.PropertiesBase;
import org.luwrain.core.PropertiesProvider;

final class PropertiesRegistry
implements PropertiesBase,
PropertiesProvider.Listener {
    private Luwrain luwrain = null;
    private final PropertiesProvider[] basicProviders;
    private Provider[] providers = new Provider[0];
    private final Map<String, Provider> propsCache = new HashMap<String, Provider>();
    private final Map<String, Provider> filesPropsCache = new HashMap<String, Provider>();
    private final Map<String, List<String>> hooks = new HashMap<String, List<String>>();

    PropertiesRegistry(PropertiesProvider[] basicProviders) {
        NullCheck.notNullItems((Object[])basicProviders, (String)"basicProviders");
        this.basicProviders = (PropertiesProvider[])basicProviders.clone();
        this.setProviders(new PropertiesProvider[0]);
    }

    void setLuwrainObj(Luwrain luwrain) {
        NullCheck.notNull((Object)luwrain, (String)"luwrain");
        if (this.luwrain != null) {
            throw new IllegalStateException("Trying to set the Luwrain object twice");
        }
        this.luwrain = luwrain;
    }

    PropertiesProvider[] getBasicProviders() {
        return (PropertiesProvider[])this.basicProviders.clone();
    }

    @Override
    public void onNewPropertyValue(String propName, String propValue) {
        NullCheck.notEmpty((Object)propName, (String)"propName");
        NullCheck.notNull((Object)propValue, (String)"propValue");
    }

    boolean setProviders(PropertiesProvider[] providers) {
        NullCheck.notNullItems((Object[])providers, (String)"providers");
        ArrayList<Provider> newProviders = new ArrayList<Provider>();
        for (PropertiesProvider p : this.basicProviders) {
            newProviders.add(new Provider(true, p));
        }
        for (PropertiesProvider p : providers) {
            newProviders.add(new Provider(false, p));
        }
        for (Provider p : newProviders) {
            p.provider.setListener(this);
        }
        this.providers = newProviders.toArray(new Provider[newProviders.size()]);
        this.propsCache.clear();
        this.filesPropsCache.clear();
        return true;
    }

    @Override
    public String getProperty(String propName) {
        String value;
        NullCheck.notEmpty((Object)propName, (String)"propName");
        if (this.propsCache.containsKey(propName)) {
            String value2 = this.propsCache.get((Object)propName).provider.getProperty(propName);
            if (value2 != null) {
                return value2;
            }
            this.propsCache.remove(propName);
        }
        for (Provider p : this.providers) {
            if (!p.basic || !p.hasResponsibilitySpace() || !p.matches(propName) || (value = p.provider.getProperty(propName)) == null) continue;
            this.propsCache.put(propName, p);
            return value;
        }
        for (Provider p : this.providers) {
            if (!p.basic || p.hasResponsibilitySpace() || (value = p.provider.getProperty(propName)) == null) continue;
            this.propsCache.put(propName, p);
            return value;
        }
        for (Provider p : this.providers) {
            if (p.basic || !p.hasResponsibilitySpace() || !p.matches(propName) || (value = p.provider.getProperty(propName)) == null) continue;
            this.propsCache.put(propName, p);
            return value;
        }
        for (Provider p : this.providers) {
            if (p.basic || p.hasResponsibilitySpace() || (value = p.provider.getProperty(propName)) == null) continue;
            this.propsCache.put(propName, p);
            return value;
        }
        return "";
    }

    @Override
    public File getFileProperty(String propName) {
        NullCheck.notNull((Object)propName, (String)"propName");
        for (Provider p : this.providers) {
            String value;
            if (p.hasResponsibilitySpace() || (value = p.provider.getProperty(propName)) == null || value.isEmpty()) continue;
            return new File(value);
        }
        return null;
    }

    private static final class Provider {
        final boolean basic;
        final PropertiesProvider provider;
        final Pattern[] patterns;

        Provider(boolean basic, PropertiesProvider provider) {
            NullCheck.notNull((Object)provider, (String)"provider");
            this.basic = basic;
            this.provider = provider;
            Object[] regex = provider.getPropertiesRegex();
            NullCheck.notNullItems((Object[])regex, (String)"regex");
            ArrayList<Pattern> patterns = new ArrayList<Pattern>();
            for (Object r : regex) {
                if (((String)r).isEmpty()) continue;
                patterns.add(Pattern.compile((String)r));
            }
            this.patterns = patterns.toArray(new Pattern[patterns.size()]);
        }

        boolean hasResponsibilitySpace() {
            return this.patterns.length > 0;
        }

        boolean matches(String propName) {
            NullCheck.notEmpty((Object)propName, (String)"propName");
            for (Pattern p : this.patterns) {
                Matcher matcher = p.matcher(propName);
                if (!matcher.find()) continue;
                return true;
            }
            return false;
        }
    }
}

