/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.core;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.luwrain.app.crash.App;
import org.luwrain.core.Application;
import org.luwrain.core.Area;
import org.luwrain.core.AreaQuery;
import org.luwrain.core.AreaText;
import org.luwrain.core.Base;
import org.luwrain.core.Clipboard;
import org.luwrain.core.ConfigUpdate;
import org.luwrain.core.ContentTypes;
import org.luwrain.core.Core;
import org.luwrain.core.EmptyJobListener;
import org.luwrain.core.EventDispatching;
import org.luwrain.core.EventResponse;
import org.luwrain.core.ExtensionException;
import org.luwrain.core.ExtensionObject;
import org.luwrain.core.FileFetcher;
import org.luwrain.core.Hint;
import org.luwrain.core.HookContainer;
import org.luwrain.core.Interaction;
import org.luwrain.core.Job;
import org.luwrain.core.Luwrain;
import org.luwrain.core.MediaResourcePlayer;
import org.luwrain.core.NullCheck;
import org.luwrain.core.ObjFactory;
import org.luwrain.core.Popup;
import org.luwrain.core.ScriptFile;
import org.luwrain.core.ScriptSource;
import org.luwrain.core.Sounds;
import org.luwrain.core.UniRefInfo;
import org.luwrain.core.events.InputEvent;
import org.luwrain.core.events.SystemEvent;
import org.luwrain.core.events.resp.HintResponse;
import org.luwrain.core.queries.CurrentDirQuery;
import org.luwrain.core.queries.UniRefAreaQuery;
import org.luwrain.core.queries.UniRefHotPointQuery;
import org.luwrain.core.queries.UrlAreaQuery;
import org.luwrain.core.queries.UrlHotPointQuery;
import org.luwrain.i18n.I18n;
import org.luwrain.i18n.LangStatic;
import org.luwrain.io.websearch.Engine;
import org.luwrain.player.Player;
import org.luwrain.script.Hooks;
import org.luwrain.script.core.MapScriptObject;
import org.luwrain.speech.Channel;
import org.luwrain.speech.SpeechException;

final class LuwrainImpl
implements Luwrain {
    private static final Logger log = LogManager.getLogger();
    private final Core core;

    LuwrainImpl(Core core) {
        Objects.requireNonNull(core, "core can't be null");
        this.core = core;
    }

    public <E> void saveConf(E conf) {
        this.core.configs.save(Objects.requireNonNull(conf, "conf can't be null"));
    }

    public <E> E loadConf(Class<E> cl) {
        Objects.requireNonNull(cl, "cl can't be null");
        return this.core.configs.load(cl);
    }

    @Override
    public String getDir(String type) {
        Objects.requireNonNull(type, "type can't be null");
        if (type.isEmpty()) {
            throw new IllegalArgumentException("type can't b empty ");
        }
        if (type.indexOf("/") >= 0) {
            throw new IllegalArgumentException("type can't contain  slashes");
        }
        if (type.equals("~")) {
            return this.core.conf.getUserHomeDir().getAbsolutePath();
        }
        if (!type.startsWith("var:")) {
            return null;
        }
        Path res = this.core.conf.getUserVarDir().toPath().resolve(type.substring(4));
        try {
            Files.createDirectories(res, new FileAttribute[0]);
            return res.toString();
        }
        catch (IOException ex) {
            log.error("Unable to create var dir for '" + type + "'", (Throwable)ex);
            return null;
        }
    }

    @Override
    public <C> void updateConf(Class<C> configClass, ConfigUpdate<C> func) {
        Objects.requireNonNull(configClass, "configClass can't be null");
        Objects.requireNonNull(func, "func can't be null");
        this.core.configs.update(configClass, func);
    }

    @Override
    public String getActiveAreaText(Luwrain.AreaTextType type, boolean issueErrorMessages) {
        Objects.requireNonNull(type, "type can't be null");
        this.core.mainCoreThreadOnly();
        Area activeArea = this.core.getActiveArea(issueErrorMessages);
        if (activeArea == null) {
            return null;
        }
        return new AreaText(activeArea).get(type);
    }

    @Override
    public String getActiveAreaAttr(Luwrain.AreaAttr attr) {
        Objects.requireNonNull(attr, "attr can't be null");
        this.core.mainCoreThreadOnly();
        Area area = this.core.tiles.getActiveArea();
        if (area == null) {
            return attr == Luwrain.AreaAttr.DIRECTORY ? this.core.conf.getUserHomeDir().getAbsolutePath() : null;
        }
        switch (attr) {
            case DIRECTORY: {
                CurrentDirQuery query = new CurrentDirQuery();
                if (!AreaQuery.ask(area, query)) {
                    return this.core.conf.getUserHomeDir().toString();
                }
                return query.getAnswer();
            }
            case UNIREF: {
                UniRefAreaQuery query = new UniRefAreaQuery();
                if (!AreaQuery.ask(area, query)) {
                    return null;
                }
                return query.getAnswer();
            }
            case UNIREF_UNDER_HOT_POINT: {
                UniRefHotPointQuery query = new UniRefHotPointQuery();
                if (!AreaQuery.ask(area, query)) {
                    return null;
                }
                return query.getAnswer();
            }
            case URL: {
                UrlAreaQuery query = new UrlAreaQuery();
                if (AreaQuery.ask(area, query)) {
                    return query.getAnswer();
                }
                UniRefAreaQuery query2 = new UniRefAreaQuery();
                if (!AreaQuery.ask(area, query2)) {
                    return null;
                }
                return LuwrainImpl.extractUrl(query2.getAnswer());
            }
            case URL_UNDER_HOT_POINT: {
                UrlHotPointQuery query = new UrlHotPointQuery();
                if (AreaQuery.ask(area, query)) {
                    return query.getAnswer();
                }
                UniRefHotPointQuery query2 = new UniRefHotPointQuery();
                if (!AreaQuery.ask(area, query2)) {
                    return null;
                }
                return LuwrainImpl.extractUrl(query2.getAnswer());
            }
        }
        return null;
    }

    @Override
    public boolean announcement(String text, Luwrain.AnnouncementType type, String component, String category, Map<String, String> args) {
        NullCheck.notNull((Object)text, (String)"text");
        NullCheck.notNull((Object)((Object)type), (String)"type");
        NullCheck.notEmpty((Object)component, (String)"component");
        NullCheck.notEmpty((Object)category, (String)"category");
        if (text.trim().isEmpty()) {
            return true;
        }
        HashMap<String, String> a = args != null ? new HashMap<String, String>(args) : new HashMap();
        AtomicBoolean res = new AtomicBoolean(false);
        this.runUiSafely(() -> res.set(Hooks.chainOfResponsibilityNoExc(this, "luwrain.announcement", new Object[]{new MapScriptObject().add("type", type.toString()).add("text", text).add("component", component).add("category", category).add("args", new MapScriptObject(a))})));
        return res.get();
    }

    @Override
    public void sendBroadcastEvent(SystemEvent e) {
        NullCheck.notNull((Object)e, (String)"e");
        this.core.enqueueEvent(e);
    }

    @Override
    public void sendInputEvent(InputEvent e) {
        NullCheck.notNull((Object)e, (String)"e");
        this.core.enqueueEvent(e);
    }

    @Override
    public boolean xQuit() {
        this.core.mainCoreThreadOnly();
        this.core.quit();
        return true;
    }

    @Override
    public Path getAppDataDir(String appName) {
        NullCheck.notEmpty((Object)appName, (String)"appName");
        if (appName.indexOf("/") >= 0) {
            throw new IllegalArgumentException("appName contains illegal characters");
        }
        Path res = this.getFileProperty("luwrain.dir.appdata").toPath().resolve(appName);
        try {
            Files.createDirectories(res, new FileAttribute[0]);
            return res;
        }
        catch (IOException e) {
            Base.error("unable to prepare application data directory:" + res.toString() + ":" + e.getClass().getName() + ":" + e.getMessage());
            return null;
        }
    }

    @Override
    public void closeApp() {
        this.core.mainCoreThreadOnly();
        this.core.closeApp(this);
    }

    @Override
    public String getPath(String pathId) {
        switch (Objects.requireNonNull(pathId, "pathId can't be null")) {
            case "SYS_DATA_DIR": {
                return this.core.conf.getDataDir().getAbsolutePath();
            }
            case "SYS_JS_DIR": {
                return this.core.conf.getJsDir().getAbsolutePath();
            }
        }
        if (pathId.startsWith("var:") || pathId.startsWith("VAR:") && pathId.length() >= 5) {
            File f = new File(this.core.conf.userVarDir, pathId.substring(4));
            try {
                Files.createDirectories(f.toPath(), new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return f.getAbsolutePath();
        }
        return null;
    }

    @Override
    public String getString(String strId) {
        Objects.requireNonNull(strId, "strId");
        if (strId.startsWith("static:") || strId.startsWith("STATIC:")) {
            String s = strId.substring(7);
            if (s.isEmpty()) {
                return null;
            }
            return this.core.i18n.getStaticStr(s);
        }
        return null;
    }

    @Override
    public I18n i18n() {
        return this.core.i18n;
    }

    @Override
    public void crash(App app) {
        NullCheck.notNull((Object)app, (String)"app");
        this.runUiSafely(() -> this.core.launchAppCrash(app));
    }

    @Override
    public void crash(Throwable e) {
        NullCheck.notNull((Object)e, (String)"e");
        e.printStackTrace();
        LuwrainImpl instance = this;
        this.runUiSafely(() -> this.core.launchAppCrash(this, e));
    }

    @Override
    public void launchApp(String shortcutName) {
        NullCheck.notNull((Object)shortcutName, (String)"shortcutName");
        this.runUiSafely(() -> this.core.launchApp(shortcutName, new String[0]));
    }

    @Override
    public void launchApp(String shortcutName, String[] args) {
        NullCheck.notNull((Object)shortcutName, (String)"shortcutName");
        NullCheck.notNullItems((Object[])args, (String)"args");
        this.runUiSafely(() -> this.core.launchApp(shortcutName, args != null ? args : new String[]{}));
    }

    @Override
    public void message(String text) {
        NullCheck.notNull((Object)text, (String)"text");
        if (text.trim().isEmpty()) {
            return;
        }
        this.runUiSafely(() -> {
            this.core.braille.textToSpeak(text);
            this.core.message(text, Luwrain.MessageType.REGULAR);
        });
    }

    @Override
    public void message(String text, Luwrain.MessageType messageType) {
        NullCheck.notNull((Object)text, (String)"text");
        NullCheck.notNull((Object)((Object)messageType), (String)"messageType");
        if (text.trim().isEmpty()) {
            return;
        }
        this.runUiSafely(() -> {
            this.core.braille.textToSpeak(text);
            this.core.message(text, messageType);
        });
    }

    @Override
    public void message(String text, Sounds sound) {
        NullCheck.notNull((Object)text, (String)"text");
        NullCheck.notNull((Object)((Object)sound), (String)"sound");
        if (text.trim().isEmpty()) {
            return;
        }
        this.runUiSafely(() -> {
            this.core.braille.textToSpeak(text);
            this.core.message(text, sound);
        });
    }

    @Override
    public <T> T createInstance(Class<T> c) {
        Objects.requireNonNull(c, "c can't be null");
        List<ObjFactory> factories = this.core.extensions.getLoadedExtObjects(ObjFactory.class);
        for (ObjFactory f : factories) {
            Object res = f.newObject(c.getName());
            if (res == null) continue;
            return (T)res;
        }
        return null;
    }

    @Override
    public <T> List<T> createInstances(Class<T> c) {
        Objects.requireNonNull(c, "c can't be null");
        if (c.equals(Engine.class)) {
            return this.core.extensions.load(c);
        }
        return null;
    }

    @Override
    public FileFetcher[] findFetchers(String url) {
        NullCheck.notEmpty((Object)url, (String)"url");
        ArrayList<FileFetcher> fetchers = new ArrayList<FileFetcher>(this.core.extensions.getLoadedExtObjects(FileFetcher.class));
        fetchers.removeIf(f -> !f.canHandleUrl(url));
        return fetchers.toArray(new FileFetcher[fetchers.size()]);
    }

    @Override
    public void onAreaNewHotPoint(Area area) {
        NullCheck.notNull((Object)area, (String)"area");
        this.core.mainCoreThreadOnly();
        Area frontArea = this.core.getFrontAreaFor(this, area);
        if (frontArea == null) {
            return;
        }
        if (frontArea == this.core.tiles.getActiveArea()) {
            this.core.windowManager.redrawArea(frontArea);
        }
    }

    @Override
    public void onAreaNewContent(Area area) {
        NullCheck.notNull((Object)area, (String)"area");
        this.core.mainCoreThreadOnly();
        Area frontArea = this.core.getFrontAreaFor(this, area);
        if (frontArea == null) {
            return;
        }
        this.core.windowManager.redrawArea(frontArea);
    }

    @Override
    public void onAreaNewName(Area area) {
        NullCheck.notNull((Object)area, (String)"area");
        this.core.mainCoreThreadOnly();
        Area frontArea = this.core.getFrontAreaFor(this, area);
        if (frontArea == null) {
            return;
        }
        this.core.windowManager.redrawArea(frontArea);
    }

    @Override
    public void onAreaNewBackgroundSound(Area area) {
        NullCheck.notNull((Object)area, (String)"area");
        this.core.mainCoreThreadOnly();
        Area frontArea = this.core.getFrontAreaFor(this, area);
        if (frontArea == null) {
            return;
        }
        this.core.updateBackgroundSound(frontArea);
    }

    @Override
    public int getAreaVisibleHeight(Area area) {
        NullCheck.notNull((Object)area, (String)"area");
        this.core.mainCoreThreadOnly();
        return this.core.getAreaVisibleHeightIface(this, area);
    }

    @Override
    public int getAreaVisibleWidth(Area area) {
        NullCheck.notNull((Object)area, (String)"area");
        this.core.mainCoreThreadOnly();
        return this.core.getAreaVisibleWidthIface(this, area);
    }

    @Override
    public int getScreenWidth() {
        this.core.mainCoreThreadOnly();
        return this.core.getScreenWidthIface();
    }

    @Override
    public int getScreenHeight() {
        this.core.mainCoreThreadOnly();
        return this.core.getScreenHeightIface();
    }

    @Override
    public void announceActiveArea() {
        this.core.mainCoreThreadOnly();
        this.core.announceActiveAreaIface();
    }

    @Override
    public Clipboard getClipboard() {
        return this.core.getClipboard();
    }

    @Override
    public void onNewAreaLayout() {
        this.core.mainCoreThreadOnly();
        this.core.onNewAreaLayout(this);
    }

    @Override
    public void openFile(String fileName) {
        Objects.requireNonNull(fileName, "fileName can't be null");
        if (fileName.isEmpty()) {
            throw new IllegalArgumentException("fileName can't be null");
        }
        this.runUiSafely(() -> this.core.fileTypes.launch(this.core, new String[]{fileName}));
    }

    @Override
    public void openFiles(String[] fileNames) {
        Objects.requireNonNull(fileNames, "fileNames");
        if (fileNames.length == 0) {
            throw new IllegalArgumentException("fileNames can't be empty");
        }
        for (String s : fileNames) {
            if (!Objects.requireNonNullElse(s, "").isEmpty()) continue;
            throw new IllegalArgumentException("fileNames can't contain empty items");
        }
        this.runUiSafely(() -> this.core.fileTypes.launch(this.core, fileNames));
    }

    @Override
    public boolean openHelp(String sectName) {
        NullCheck.notEmpty((Object)sectName, (String)"sectName");
        this.core.mainCoreThreadOnly();
        String url = this.core.helpSects.getSectionUrl(sectName);
        if (url.isEmpty()) {
            return false;
        }
        this.launchApp("reader", new String[]{url});
        return true;
    }

    @Override
    public String suggestContentType(URL url, ContentTypes.ExpectedType expectedType) {
        NullCheck.notNull((Object)url, (String)"url");
        NullCheck.notNull((Object)((Object)expectedType), (String)"expectedType");
        return this.core.contentTypes.suggestContentType(url, expectedType);
    }

    @Override
    public String suggestContentType(File file, ContentTypes.ExpectedType expectedType) {
        NullCheck.notNull((Object)file, (String)"file");
        NullCheck.notNull((Object)((Object)expectedType), (String)"expectedType");
        return this.core.contentTypes.suggestContentType(file, expectedType);
    }

    @Override
    public void playSound(Sounds sound) {
        this.runUiSafely(() -> this.core.soundManager.playIcon(sound));
    }

    @Override
    public void playSound(File file) {
        NullCheck.notNull((Object)file, (String)"file");
        this.runUiSafely(() -> this.core.soundManager.playIcon(file));
    }

    @Override
    public void popup(Popup popup) {
        NullCheck.notNull((Object)popup, (String)"popup");
        this.core.mainCoreThreadOnly();
        Luwrain luwrainObj = popup.getLuwrainObject();
        if (luwrainObj == null) {
            throw new IllegalArgumentException("The popup doesn't contain any Luwrain object");
        }
        Base.StopCondition stopCondition = () -> popup.isPopupActive();
        if (this.core.interfaces.forPopupsWithoutApp(luwrainObj)) {
            this.core.popup(null, popup, Popup.Position.BOTTOM, stopCondition, popup.getPopupFlags());
            return;
        }
        Application app = this.core.interfaces.findApp(luwrainObj);
        if (app == null) {
            Base.warn("trying to open a popup with the Luwrain obj which isn't allowed to open popups");
            throw new IllegalArgumentException("the luwrain object provided by the popup isn't allowed to open popups");
        }
        this.core.popup(app, popup, Popup.Position.BOTTOM, stopCondition, popup.getPopupFlags());
    }

    @Override
    public boolean runCommand(String command) {
        NullCheck.notNull((Object)command, (String)"command");
        this.core.mainCoreThreadOnly();
        return this.core.runCommand(command);
    }

    @Override
    public Job newJob(String name, String[] args, String dir, Set<Luwrain.JobFlags> flags, Job.Listener listener) {
        Objects.requireNonNull(name, "name can't be null");
        Objects.requireNonNull(args, "args can't be null");
        Objects.requireNonNull(dir, "dir can't be null");
        Objects.requireNonNull(flags, "flags can't be null");
        this.core.mainCoreThreadOnly();
        return this.core.jobs.run(name, args, dir, listener != null ? listener : new EmptyJobListener());
    }

    @Override
    public void speak(String text) {
        NullCheck.notNull((Object)text, (String)"text");
        this.runUiSafely(() -> {
            this.core.braille.textToSpeak(text);
            this.core.speech.speak(this.core.speakingText.processRegular(text), 0, 0);
        });
    }

    @Override
    public void speak(String text, Sounds sound) {
        NullCheck.notNull((Object)text, (String)"text");
        NullCheck.notNull((Object)((Object)sound), (String)"sound");
        this.runUiSafely(() -> {
            this.playSound(sound);
            this.speak(text);
        });
    }

    @Override
    public void speak(String text, int pitch) {
        NullCheck.notNull((Object)text, (String)"text");
        this.runUiSafely(() -> {
            this.core.braille.textToSpeak(text);
            this.core.speech.speak(this.core.speakingText.processRegular(text), pitch, 0);
        });
    }

    @Override
    public void speak(String text, int pitch, int rate) {
        NullCheck.notNull((Object)text, (String)"text");
        this.runUiSafely(() -> this.core.speech.speak(this.core.speakingText.processRegular(text), pitch, rate));
    }

    @Override
    public void speakLetter(char letter) {
        this.core.braille.textToSpeak("" + letter);
        this.runUiSafely(() -> {
            switch (letter) {
                case ' ': {
                    this.immediateHint(Hint.SPACE);
                    return;
                }
                case '\t': {
                    this.immediateHint(Hint.TAB);
                    return;
                }
            }
            String value = this.i18n().hasSpecialNameOfChar(letter);
            if (value == null) {
                this.core.speech.speakLetter(letter, 0, 0);
            } else {
                this.speak(value, -25);
            }
        });
    }

    @Override
    public void speakLetter(char letter, int pitch) {
        this.runUiSafely(() -> {
            switch (letter) {
                case ' ': {
                    this.immediateHint(Hint.SPACE);
                    return;
                }
                case '\t': {
                    this.immediateHint(Hint.TAB);
                    return;
                }
            }
            String value = this.i18n().hasSpecialNameOfChar(letter);
            if (value == null) {
                this.core.speech.speakLetter(letter, pitch, 0);
            } else {
                this.speak(value, -25);
            }
        });
    }

    @Override
    public void speakLetter(char letter, int pitch, int rate) {
        this.runUiSafely(() -> {
            switch (letter) {
                case ' ': {
                    this.immediateHint(Hint.SPACE);
                    return;
                }
                case '\t': {
                    this.immediateHint(Hint.TAB);
                    return;
                }
            }
            String value = this.i18n().hasSpecialNameOfChar(letter);
            if (value == null) {
                this.core.speech.speakLetter(letter, pitch, rate);
            } else {
                this.speak(value, -25);
            }
        });
    }

    @Override
    public void silence() {
        this.runUiSafely(() -> this.core.speech.silence());
    }

    @Override
    public void setActiveArea(Area area) {
        NullCheck.notNull((Object)area, (String)"area");
        this.core.mainCoreThreadOnly();
        Application app = this.core.interfaces.findApp(this);
        if (app == null) {
            throw new IllegalArgumentException("Trying to use an illegal Luwrain obj");
        }
        this.core.apps.setActiveAreaForApp(app, area);
        if (this.core.apps.isActiveApp(app) && !this.core.tiles.isPopupActive()) {
            this.core.setAreaIntroduction();
        }
        this.core.onNewAreasLayout();
    }

    @Override
    public String staticStr(LangStatic id) {
        NullCheck.notNull((Object)((Object)id), (String)"id");
        this.core.mainCoreThreadOnly();
        return this.i18n().staticStr(id);
    }

    @Override
    public UniRefInfo getUniRefInfo(String uniRef) {
        NullCheck.notNull((Object)uniRef, (String)"uniRef");
        return this.core.uniRefProcs.getInfo(uniRef);
    }

    @Override
    public boolean openUniRef(String uniRef) {
        NullCheck.notNull((Object)uniRef, (String)"uniRef");
        this.core.mainCoreThreadOnly();
        return this.core.uniRefProcs.open(uniRef);
    }

    @Override
    public boolean openUniRef(UniRefInfo uniRefInfo) {
        NullCheck.notNull((Object)uniRefInfo, (String)"uniRefInfo");
        this.core.mainCoreThreadOnly();
        return this.core.uniRefProcs.open(uniRefInfo.getValue());
    }

    @Override
    public boolean openUrl(String url) {
        NullCheck.notEmpty((Object)url, (String)"url");
        AtomicBoolean res = new AtomicBoolean(false);
        this.runUiSafely(() -> res.set(Hooks.chainOfResponsibilityNoExc(this, "luwrain.url.open", new Object[]{url})));
        return res.get();
    }

    @Override
    public void runUiSafely(Runnable runnable) {
        NullCheck.notNull((Object)runnable, (String)"runnable");
        if (!this.core.isMainCoreThread()) {
            this.runInMainThread(runnable);
        } else {
            runnable.run();
        }
    }

    @Override
    public Object runLaterSync(Callable callable) {
        NullCheck.notNull((Object)callable, (String)"callable");
        EventDispatching.CallableEvent event = new EventDispatching.CallableEvent(callable);
        this.core.enqueueEvent(event);
        try {
            event.waitForBeProcessed();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
        return event.getResult();
    }

    @Override
    public Object callUiSafely(Callable callable) {
        NullCheck.notNull((Object)callable, (String)"callable");
        if (this.core.isMainCoreThread()) {
            try {
                return callable.call();
            }
            catch (Throwable e) {
                Base.error(e, "exception on processing of CallableEvent");
                return null;
            }
        }
        return this.runLaterSync(callable);
    }

    @Override
    public int xGetSpeechRate() {
        this.core.mainCoreThreadOnly();
        return this.core.speech.getRate();
    }

    @Override
    public void xSetSpeechRate(int value) {
        this.core.mainCoreThreadOnly();
        this.core.speech.setRate(value);
    }

    @Override
    public int xGetSpeechPitch() {
        this.core.mainCoreThreadOnly();
        return this.core.speech.getPitch();
    }

    @Override
    public void xSetSpeechPitch(int value) {
        this.core.mainCoreThreadOnly();
        this.core.speech.setPitch(value);
    }

    @Override
    public String[] getAllShortcutNames() {
        this.core.mainCoreThreadOnly();
        return this.core.objRegistry.getShortcutNames();
    }

    @Override
    public File getFileProperty(String propName) {
        NullCheck.notEmpty((Object)propName, (String)"propName");
        return null;
    }

    @Override
    public String getProperty(String propName) {
        NullCheck.notEmpty((Object)propName, (String)"propName");
        return null;
    }

    @Override
    public void setEventResponse(EventResponse eventResponse) {
        NullCheck.notNull((Object)eventResponse, (String)"eventResponse");
        this.core.mainCoreThreadOnly();
        this.core.setEventResponse(eventResponse);
    }

    @Override
    public Player getPlayer() {
        return this.core.player;
    }

    @Override
    public MediaResourcePlayer[] getMediaResourcePlayers() {
        this.core.mainCoreThreadOnly();
        ArrayList<MediaResourcePlayer> res = new ArrayList<MediaResourcePlayer>();
        res.add(this.core.wavePlayer);
        for (MediaResourcePlayer p : this.core.objRegistry.getMediaResourcePlayers()) {
            res.add(p);
        }
        return res.toArray(new MediaResourcePlayer[res.size()]);
    }

    @Override
    public String[] xGetLoadedSpeechFactories() {
        this.core.mainCoreThreadOnly();
        return new String[0];
    }

    @Override
    public boolean runWorker(String workerName) {
        NullCheck.notEmpty((Object)workerName, (String)"workerName");
        this.core.mainCoreThreadOnly();
        return this.core.workers.runExplicitly(workerName);
    }

    @Override
    public void executeBkg(Runnable runnable) {
        NullCheck.notNull((Object)runnable, (String)"runnable");
        new Thread(() -> {
            try {
                runnable.run();
            }
            catch (Throwable e) {
                Base.error(e, "exception in a background thread");
                this.crash(e);
            }
        }).start();
    }

    @Override
    public boolean registerExtObj(ExtensionObject extObj) {
        NullCheck.notNull((Object)extObj, (String)"extObj");
        this.core.mainCoreThreadOnly();
        if (this != this.core.luwrain) {
            throw new RuntimeException("registerExtObj() may be called only for privileged interfaces");
        }
        return this.core.objRegistry.add(null, extObj);
    }

    @Override
    public Channel loadSpeechChannel(String engineName, String params) throws SpeechException {
        NullCheck.notEmpty((Object)engineName, (String)"engineName");
        NullCheck.notNull((Object)params, (String)"params");
        return this.core.speech.loadChannel(engineName, params);
    }

    @Override
    public boolean unloadDynamicExtension(String extId) {
        NullCheck.notEmpty((Object)extId, (String)"extId");
        this.core.mainCoreThreadOnly();
        return this.core.unloadDynamicExtension(extId);
    }

    @Override
    public String getSpeakableText(String text, Luwrain.SpeakableTextType type) {
        NullCheck.notNull((Object)text, (String)"text");
        NullCheck.notNull((Object)((Object)type), (String)"type");
        return this.core.i18n.getSpeakableText(text, type);
    }

    @Override
    public boolean runHooks(String hookName, HookContainer.HookRunner runner) {
        NullCheck.notEmpty((Object)hookName, (String)"hookName");
        NullCheck.notNull((Object)runner, (String)"runner");
        this.core.extensions.runHooks(hookName, runner);
        return true;
    }

    @Override
    public void showGraphical(Interaction.GraphicalMode graphicalMode) {
        NullCheck.notNull((Object)graphicalMode, (String)"graphicalMode");
        this.core.interaction.showGraphical(graphicalMode);
    }

    @Override
    public ScriptFile[] getScriptFilesList(String componentName) {
        NullCheck.notEmpty((Object)componentName, (String)"componentName");
        List<ScriptFile> res = this.core.extensions.getScriptFiles(componentName);
        return res.toArray(new ScriptFile[res.size()]);
    }

    @Override
    public String loadScript(ScriptSource scriptSource) throws ExtensionException {
        NullCheck.notNull((Object)scriptSource, (String)"scriptSource");
        return this.core.loadScript(scriptSource);
    }

    @Override
    public String escapeString(String style, String text) {
        NullCheck.notNull((Object)style, (String)"style");
        NullCheck.notNull((Object)text, (String)"text");
        return this.core.os.escapeString(style, text);
    }

    @Override
    public File createTempFile(String prefix) {
        NullCheck.notNull((Object)prefix, (String)"prefix");
        return this.core.tempFiles.createTempFile(!prefix.trim().isEmpty() ? prefix.trim() : "unknown");
    }

    private void immediateHint(Hint hint) {
        Objects.requireNonNull(hint, "hint can't be null");
        HintResponse r = new HintResponse(hint);
        r.announce(this, this.core.eventResponseSpeech, this.core.commonSett);
    }

    private void runInMainThread(Runnable runnable) {
        NullCheck.notNull((Object)runnable, (String)"runnable");
        this.core.enqueueEvent(new EventDispatching.RunnableEvent(() -> {
            try {
                runnable.run();
            }
            catch (Throwable e) {
                this.crash(e);
            }
        }));
    }

    private static String extractUrl(String uniRef) {
        NullCheck.notNull((Object)uniRef, (String)"uniRef");
        if (!uniRef.startsWith("url:")) {
            return null;
        }
        return uniRef.substring("url:".length());
    }
}

