/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.core;

import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.luwrain.core.NullCheck;

public final class Log {
    private static final Logger LOG = LogManager.getLogger();
    private static final List<Listener> listeners = new ArrayList<Listener>();

    public static void addListener(Listener listener) {
        NullCheck.notNull((Object)listener, (String)"listener");
        for (int i = 0; i < listeners.size(); ++i) {
            if (listeners.get(i) != listener) continue;
            return;
        }
        listeners.add(listener);
    }

    public static void removeListener(Listener listener) {
        NullCheck.notNull((Object)listener, (String)"listener");
        for (int i = 0; i < listeners.size(); ++i) {
            if (listeners.get(i) != listener) continue;
            listeners.remove(i);
            return;
        }
    }

    public static void debug(String component, String message) {
        LOG.debug(message);
    }

    public static void info(String component, String message) {
        LOG.info(message);
    }

    public static void warning(String component, String message) {
        LOG.warn(message);
    }

    public static void error(String component, String message) {
        LOG.error(message);
    }

    public static void fatal(String component, String message) {
        LOG.fatal(message);
    }

    public static interface Listener {
        public void onLogMessage(Message var1);
    }

    public static final class Message {
        public final Level level;
        public final String component;
        public final String message;

        Message(Level level, String component, String message) {
            NullCheck.notNull((Object)((Object)level), (String)"level");
            NullCheck.notNull((Object)component, (String)"component");
            NullCheck.notNull((Object)message, (String)"message");
            this.level = level;
            this.component = component;
            this.message = message;
        }
    }

    public static enum Level {
        DEBUG,
        INFO,
        WARNING,
        ERROR,
        FATAL;

    }
}

