/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.core;

import java.util.ArrayList;
import java.util.List;
import org.luwrain.core.Area;
import org.luwrain.core.NullCheck;
import org.luwrain.core.OpenedArea;
import org.luwrain.core.events.SystemEvent;

class LaunchedAppPopups {
    final List<OpenedArea> popupWrappings = new ArrayList<OpenedArea>();

    LaunchedAppPopups() {
    }

    int addPopup(Area popup) {
        NullCheck.notNull((Object)popup, (String)"popup");
        OpenedArea wrapping = new OpenedArea(popup);
        this.popupWrappings.add(wrapping);
        return this.popupWrappings.size() - 1;
    }

    void closeLastPopup() {
        this.popupWrappings.remove(this.popupWrappings.size() - 1);
    }

    Area getNativeAreaOfPopup(int index) {
        if (index < 0 || index >= this.popupWrappings.size()) {
            throw new IllegalArgumentException("index (" + index + ") must be non-negative and less than " + this.popupWrappings.size());
        }
        return this.popupWrappings.get((int)index).area;
    }

    Area getFrontAreaOfPopup(int index) {
        if (index < 0 || index >= this.popupWrappings.size()) {
            throw new IllegalArgumentException("index (" + index + ") must be non-negative and less than " + this.popupWrappings.size());
        }
        return this.popupWrappings.get(index).getFrontArea();
    }

    Area getCorrespondingFrontArea(Area area) {
        NullCheck.notNull((Object)area, (String)"area");
        for (OpenedArea w : this.popupWrappings) {
            if (!w.hasArea(area)) continue;
            return w.getFrontArea();
        }
        return null;
    }

    OpenedArea getAreaWrapping(Area area) {
        NullCheck.notNull((Object)area, (String)"area");
        for (OpenedArea w : this.popupWrappings) {
            if (!w.hasArea(area)) continue;
            return w;
        }
        return null;
    }

    void sendBroadcastEvent(SystemEvent event) {
        NullCheck.notNull((Object)event, (String)"event");
        for (OpenedArea area : this.popupWrappings) {
            area.area.onSystemEvent(event);
        }
    }
}

