/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.luwrain.core.ExtensionsManager;
import org.luwrain.core.Job;
import org.luwrain.core.JobLauncher;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;

public final class JobsManager {
    private static final Logger log = LogManager.getLogger();
    private final Luwrain luwrain;
    private final ExtensionsManager ext;
    public final List<Entry> entries = new ArrayList<Entry>();

    JobsManager(Luwrain luwrain, ExtensionsManager ext) {
        this.luwrain = Objects.requireNonNull(luwrain, "luwrain can't be null");
        this.ext = Objects.requireNonNull(ext, "ext can't be null");
    }

    Job run(String name, String[] args, String dir, Job.Listener listener) {
        Entry entry;
        NullCheck.notEmpty((Object)name, (String)"name");
        NullCheck.notNullItems((Object[])args, (String)"args");
        Objects.requireNonNull(dir, "dir can't be null");
        Objects.requireNonNull(listener, "listener can't be null");
        Optional<JobLauncher> j = this.ext.load(JobLauncher.class).stream().filter(o -> o.getExtObjName().equals(name)).findFirst();
        if (!j.isPresent()) {
            throw new IllegalArgumentException("No such job: " + name);
        }
        JobLauncher job = j.get();
        Job instance = job.launch(entry = new Entry(listener), args, dir.isEmpty() ? null : dir);
        if (instance == null) {
            return null;
        }
        entry.setInstance(instance);
        this.entries.add(entry);
        return entry;
    }

    private void onFinish(Entry entry) {
        NullCheck.notNull((Object)entry, (String)"entry");
    }

    public final class Entry
    implements Job,
    Job.Listener {
        private final Job.Listener listener;
        private Job instance = null;
        private final Map<String, List<String>> info = new HashMap<String, List<String>>();

        Entry(Job.Listener listener) {
            NullCheck.notNull((Object)listener, (String)"listener");
            this.listener = listener;
        }

        @Override
        public String getInstanceName() {
            return this.instance.getInstanceName();
        }

        @Override
        public Job.Status getStatus() {
            return this.instance.getStatus();
        }

        @Override
        public int getExitCode() {
            return this.instance.getExitCode();
        }

        @Override
        public boolean isFinishedSuccessfully() {
            return this.instance.isFinishedSuccessfully();
        }

        @Override
        public List<String> getInfo(String infoType) {
            NullCheck.notEmpty((Object)infoType, (String)"infoType");
            List<String> res = this.info.get(infoType);
            if (res != null) {
                return res;
            }
            res = this.instance.getInfo(infoType);
            if (res == null) {
                return Arrays.asList(new String[0]);
            }
            this.info.put(infoType, res);
            return res;
        }

        @Override
        public void stop() {
            this.instance.stop();
        }

        @Override
        public void onInfoChange(Job instance, String type, List<String> value) {
            NullCheck.notEmpty((Object)type, (String)"type");
            List<String> res = value;
            if (res == null) {
                res = instance.getInfo(type);
            }
            if (res != null) {
                this.info.put(type, res);
            } else {
                res = this.info.get(type);
            }
            this.listener.onInfoChange(instance, type, res != null ? res : Arrays.asList(new String[0]));
        }

        @Override
        public void onStatusChange(Job instance) {
            this.listener.onStatusChange(this);
            if (instance.getStatus() == Job.Status.FINISHED) {
                JobsManager.this.onFinish(this);
            }
        }

        public String toString() {
            return this.getInstanceName();
        }

        void setInstance(Job instance) {
            NullCheck.notNull((Object)instance, (String)"instance");
            if (this.instance == null) {
                this.instance = instance;
            }
        }
    }
}

