/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import org.luwrain.core.Args;
import org.luwrain.core.Configs;
import org.luwrain.core.OperatingSystem;
import org.luwrain.core.events.InputEvent;
import org.luwrain.io.json.HotKey;
import org.luwrain.io.json.HotKeys;

final class GlobalKeys {
    static final HotKey[] DEFAULT_KEYMAP = new HotKey[]{GlobalKeys.cmd(InputEvent.Special.ENTER, InputEvent.Modifiers.CONTROL, "ok"), GlobalKeys.cmd(InputEvent.Special.ENTER, InputEvent.Modifiers.SHIFT, "properties"), GlobalKeys.cmd(InputEvent.Special.ESCAPE, InputEvent.Modifiers.CONTROL, "close"), GlobalKeys.cmd(InputEvent.Special.F2, "save"), GlobalKeys.cmd(InputEvent.Special.F3, "open"), GlobalKeys.cmd(InputEvent.Special.F10, InputEvent.Modifiers.SHIFT, "context-menu"), GlobalKeys.cmd('r', InputEvent.Modifiers.ALT, "run"), GlobalKeys.cmd('u', InputEvent.Modifiers.CONTROL, InputEvent.Modifiers.ALT, "copy-uri-area"), GlobalKeys.cmd('o', InputEvent.Modifiers.CONTROL, InputEvent.Modifiers.ALT, "copy-uri-hot-point"), GlobalKeys.cmd('u', InputEvent.Modifiers.CONTROL, "copy-url-area"), GlobalKeys.cmd('o', InputEvent.Modifiers.CONTROL, "copy-url-hot-point"), GlobalKeys.cmd('q', InputEvent.Modifiers.ALT, "quit"), GlobalKeys.cmd(' ', InputEvent.Modifiers.CONTROL, "region-point"), GlobalKeys.cmd('c', InputEvent.Modifiers.CONTROL, "copy"), GlobalKeys.cmd('a', InputEvent.Modifiers.CONTROL, "copy-all"), GlobalKeys.cmd('x', InputEvent.Modifiers.CONTROL, "cut"), GlobalKeys.cmd('v', InputEvent.Modifiers.CONTROL, "paste"), GlobalKeys.cmd(InputEvent.Special.ALTERNATIVE_DELETE, "clear"), GlobalKeys.cmd(InputEvent.Special.DELETE, InputEvent.Modifiers.SHIFT, "clear-region"), GlobalKeys.cmd('j', InputEvent.Modifiers.SHIFT, InputEvent.Modifiers.ALT, "jobs"), GlobalKeys.cmd('p', InputEvent.Modifiers.SHIFT, InputEvent.Modifiers.ALT, "control-panel")};
    private final Args args;
    private final List<HotKey> keys = new ArrayList<HotKey>();
    private final Configs configs;

    GlobalKeys(Args args, Configs configs) {
        this.args = args;
        this.configs = Objects.requireNonNull(configs, "configs");
    }

    String getCommandName(InputEvent event) {
        Objects.requireNonNull(event, "event can't be null");
        for (HotKey key : this.keys) {
            if (!key.getInputEvent().equals(event)) continue;
            return key.getCommand();
        }
        return null;
    }

    void load(OperatingSystem os) {
        this.keys.clear();
        if (this.args.stdGlobalKeys) {
            this.keys.addAll(List.of(DEFAULT_KEYMAP));
            this.keys.addAll(this.getOsDepKeys(os));
            return;
        }
        HotKeys conf = this.configs.load(HotKeys.class);
        if (conf == null || conf.getHotKeys() == null) {
            conf = new HotKeys();
            conf.setHotKeys(new ArrayList<HotKey>(List.of(DEFAULT_KEYMAP)));
            conf.getHotKeys().addAll(this.getOsDepKeys(os));
            this.configs.save(conf);
        }
        this.keys.addAll(conf.getHotKeys());
    }

    List<HotKey> getOsDepKeys(OperatingSystem os) {
        if (os.getClass().getSimpleName().equals("Linux")) {
            return Arrays.asList(GlobalKeys.cmd(InputEvent.Special.WINDOWS, "main-menu"));
        }
        return Arrays.asList(new HotKey[0]);
    }

    static HotKey cmd(InputEvent.Special special, String cmdName) {
        HotKey key = new HotKey();
        key.setInputEvent(new InputEvent(Objects.requireNonNull(special, "special can't be null")));
        key.setCommand(Objects.requireNonNull(cmdName, "cmdName can't be null"));
        return key;
    }

    static HotKey cmd(InputEvent.Special special, InputEvent.Modifiers modifier, String cmdName) {
        Objects.requireNonNull(special, "special can't be null");
        Objects.requireNonNull(modifier, "modifier can't be null");
        HotKey key = new HotKey();
        key.setInputEvent(new InputEvent(special, EnumSet.of(modifier)));
        key.setCommand(Objects.requireNonNull(cmdName, "cmdName can't be null"));
        return key;
    }

    static HotKey cmd(char ch, InputEvent.Modifiers modifier, String cmdName) {
        Objects.requireNonNull(modifier, "modifier can't be null");
        HotKey key = new HotKey();
        key.setInputEvent(new InputEvent(ch, EnumSet.of(modifier)));
        key.setCommand(Objects.requireNonNull(cmdName, "cmdName can't be null"));
        return key;
    }

    static HotKey cmd(char ch, InputEvent.Modifiers modifier1, InputEvent.Modifiers modifier2, String cmdName) {
        Objects.requireNonNull(modifier1, "modifier1 can't be null");
        Objects.requireNonNull(modifier2, "modifier2 can't be null");
        HotKey key = new HotKey();
        key.setInputEvent(new InputEvent(ch, EnumSet.of(modifier1, modifier2)));
        key.setCommand(Objects.requireNonNull(cmdName, "cmdName can't be null"));
        return key;
    }
}

