/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.core;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.luwrain.core.Base;
import org.luwrain.core.Extension;
import org.luwrain.core.ExtensionObject;
import org.luwrain.core.HookContainer;
import org.luwrain.core.InterfaceManager;
import org.luwrain.core.Luwrain;
import org.luwrain.core.ScriptFile;

public final class ExtensionsManager
implements AutoCloseable {
    private static final Logger log = LogManager.getLogger();
    private final Base base;
    private final InterfaceManager interfaces;
    List<Entry> extensions = new ArrayList<Entry>();

    ExtensionsManager(Base base, InterfaceManager interfaces) {
        this.base = Objects.requireNonNull(base, "base can't be null");
        this.interfaces = Objects.requireNonNull(interfaces, "interfaces can't be null");
    }

    void load(InterfaceRequest interfaceRequest, ClassLoader classLoader) {
        Objects.requireNonNull(interfaceRequest, "interfaceRequest can't be null");
        Objects.requireNonNull(classLoader, "classLoader can't be null");
        for (Extension ext : ServiceLoader.load(Extension.class)) {
            String message;
            Luwrain iface = interfaceRequest.getInterfaceObj(ext);
            try {
                log.trace("Initializing the " + ext.getClass().getName() + " extension");
                message = ext.init(iface);
            }
            catch (Throwable ex) {
                log.error("Loading of extension " + ext.getClass().getName() + " failed on extension init", ex);
                this.interfaces.release(iface);
                continue;
            }
            if (message != null) {
                log.error("Loading of extension " + ext.getClass().getName() + " failed. Message: " + message);
                this.interfaces.release(iface);
                continue;
            }
            this.extensions.add(new Entry(ext, iface));
        }
    }

    public <E> List<E> load(Class<E> cl) {
        Objects.requireNonNull(cl, "cl can't be null");
        ArrayList<E> res = new ArrayList<E>();
        for (E e : ServiceLoader.load(cl)) {
            log.trace("Loaded " + e.getClass().getName() + " as an instance of " + cl.getName());
            res.add(e);
        }
        return res;
    }

    public <E> List<E> loadFromExtensions(Class<E> c) {
        ArrayList<Object> res = new ArrayList<Object>();
        for (Entry e : this.extensions) {
            for (ExtensionObject o : e.ext.getExtObjects(e.luwrain)) {
                res.addAll(Arrays.asList(o).stream().filter(f -> c.isInstance(f)).map(f -> c.cast(f)).toList());
            }
        }
        return res;
    }

    @Override
    public void close() {
        for (Entry e : this.extensions) {
            try {
                e.ext.close();
            }
            catch (Throwable ex) {
                log.error((Object)ex);
            }
            this.interfaces.release(e.luwrain);
        }
        this.extensions = null;
    }

    public <E extends ExtensionObject> List<E> getLoadedExtObjects(Class<E> c) {
        ArrayList<ExtensionObject> res = new ArrayList<ExtensionObject>();
        for (Entry e : this.extensions) {
            for (ExtensionObject o : e.extObjects) {
                if (!c.isInstance(o)) continue;
                res.add(o);
            }
        }
        return res;
    }

    public boolean runHooks(String hookName, HookContainer.HookRunner runner) {
        Objects.requireNonNull(hookName, "hookName can't be null");
        Objects.requireNonNull(runner, "runner can't be null");
        if (hookName.isEmpty()) {
            throw new IllegalArgumentException("hookName can't be empty");
        }
        for (Entry e : this.extensions) {
            if (!(e.ext instanceof HookContainer) || ((HookContainer)((Object)e.ext)).runHooks(hookName, runner)) continue;
            return false;
        }
        return true;
    }

    List<ScriptFile> getScriptFiles(String componentName) {
        File[] packs;
        File[] files;
        Objects.requireNonNull(componentName, "componentName can't be null");
        String dataDir = this.base.conf.getDataDir().getAbsolutePath();
        ArrayList<ScriptFile> res = new ArrayList<ScriptFile>();
        File jsDir = this.base.conf.getJsDir();
        if (jsDir.exists() && jsDir.isDirectory() && (files = jsDir.listFiles()) != null) {
            for (File f : files) {
                String name;
                int pos;
                if (f == null || !f.exists() || f.isDirectory() || !f.getName().toUpperCase().endsWith(".JS") || (pos = (name = f.getName()).indexOf("-")) < 1 || pos >= name.length() - 4 || !name.substring(0, pos).toUpperCase().equals(componentName.toUpperCase())) continue;
                res.add(new ScriptFile(componentName, f.getAbsolutePath(), dataDir));
            }
        }
        for (File pack : packs = this.base.getInstalledPacksDirs()) {
            File[] files2;
            File packDataDir = new File(pack, "data");
            if (packDataDir.exists() && !packDataDir.isDirectory()) {
                log.warn("The pack contains '" + packDataDir.getAbsolutePath() + "' exists and it isn't a directory");
                continue;
            }
            if (!packDataDir.exists() && !packDataDir.mkdir()) {
                log.error("Unable to create '" + packDataDir.getAbsolutePath() + "', skipping the pack");
                continue;
            }
            File jsExtDir = new File(pack, "js");
            if (!jsExtDir.exists() || !jsExtDir.isDirectory() || (files2 = jsExtDir.listFiles()) == null) continue;
            for (File f : files2) {
                String name;
                int pos;
                if (f == null || !f.exists() || f.isDirectory() || !f.getName().toUpperCase().endsWith(".JS") || (pos = (name = f.getName()).indexOf("-")) < 1 || pos >= name.length() - 4 || !name.substring(0, pos).toUpperCase().equals(componentName.toUpperCase())) continue;
                res.add(new ScriptFile(componentName, f.getAbsolutePath(), packDataDir.getAbsolutePath()));
            }
        }
        return res;
    }

    static interface InterfaceRequest {
        public Luwrain getInterfaceObj(Extension var1);
    }

    static final class Entry {
        final Extension ext;
        final Luwrain luwrain;
        final String id;
        final ExtensionObject[] extObjects;

        Entry(Extension ext, Luwrain luwrain) {
            this.ext = Objects.requireNonNull(ext, "ext can't be null");
            this.luwrain = Objects.requireNonNull(luwrain, "luwrain can't be null");
            this.id = UUID.randomUUID().toString();
            this.extObjects = ext.getExtObjects(luwrain);
        }
    }
}

