/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.luwrain.app.crash.App;
import org.luwrain.app.crash.InitResultException;
import org.luwrain.core.Application;
import org.luwrain.core.Area;
import org.luwrain.core.Base;
import org.luwrain.core.Command;
import org.luwrain.core.Commands;
import org.luwrain.core.Config;
import org.luwrain.core.Desktop;
import org.luwrain.core.EventDispatching;
import org.luwrain.core.EventResponse;
import org.luwrain.core.ExtensionException;
import org.luwrain.core.ExtensionsManager;
import org.luwrain.core.InitResult;
import org.luwrain.core.Interaction;
import org.luwrain.core.Log;
import org.luwrain.core.Luwrain;
import org.luwrain.core.MonoApp;
import org.luwrain.core.NullCheck;
import org.luwrain.core.OperatingSystem;
import org.luwrain.core.Popup;
import org.luwrain.core.ScriptFile;
import org.luwrain.core.ScriptSource;
import org.luwrain.core.Shortcut;
import org.luwrain.core.Sounds;
import org.luwrain.core.Starter;
import org.luwrain.core.UniRefProc;
import org.luwrain.core.UniRefProcManager;
import org.luwrain.core.UniRefProcs;
import org.luwrain.core.WavePlayers;
import org.luwrain.core.events.SystemEvent;
import org.luwrain.core.speech.EventResponseSpeech;
import org.luwrain.io.json.CommonSettings;
import org.luwrain.player.Factory;
import org.luwrain.player.Player;
import org.luwrain.script.Hooks;
import org.luwrain.script.core.ScriptExtension;
import org.luwrain.shell.Conversations;

final class Core
extends EventDispatching {
    private final ClassLoader classLoader;
    final OperatingSystem os;
    final Interaction interaction;
    final Conversations conversations;
    final WavePlayers.Player wavePlayer = new WavePlayers.Player();
    final UniRefProcManager uniRefProcs = new UniRefProcManager();
    final EventResponse.Speech eventResponseSpeech;
    Player player = null;
    private Application desktop = null;
    private volatile boolean wasInputEvents = false;
    CommonSettings commonSett = null;

    Core(Config conf) {
        super(conf);
        this.classLoader = Objects.requireNonNull(conf.getCoreClassLoader(), "conf.coreClassLoader can't be null");
        this.os = Objects.requireNonNull(conf.getOperatingSystem(), "conf.operatingSystem can't be null");
        this.interaction = Objects.requireNonNull(conf.getInteraction());
        this.conversations = new Conversations(this.luwrain);
        this.eventResponseSpeech = new EventResponseSpeech(this.speech, this.i18n, this.speakingText);
    }

    void run() {
        this.init();
        this.interaction.startInputEventsAccepting(this);
        this.windowManager.redraw();
        this.workers.doWork(this.objRegistry.getWorkers());
        Hooks.chainOfResponsibilityNoExc(this.luwrain, "luwrain.startup", new Object[0]);
        this.eventLoop(this.mainStopCondition);
        this.workers.finish();
        this.soundManager.playIcon(Sounds.SHUTDOWN);
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
        this.interaction.stopInputEventsAccepting();
        this.extensions.close();
    }

    @Override
    public void onBeforeEventProcessing() {
        this.stopAreaListening();
        this.wasInputEvents = true;
    }

    @Override
    protected void processEventResponse(EventResponse eventResponse) {
        Objects.requireNonNull(eventResponse, "eventResponse can't be null");
        eventResponse.announce(this.luwrain, this.eventResponseSpeech, this.commonSett);
    }

    Area getActiveArea(boolean speakMessages) {
        Area activeArea = this.tiles.getActiveArea();
        if (activeArea == null) {
            if (speakMessages) {
                this.noAppsMessage();
            }
            return null;
        }
        return activeArea;
    }

    @Override
    public void onAltX() {
        String cmdName = this.conversations.command(this.commands.getCommandNames());
        if (cmdName == null || cmdName.trim().isEmpty()) {
            return;
        }
        if (cmdName.trim().startsWith("app ")) {
            if (!this.runAppCommand(cmdName.trim())) {
                this.message(this.i18n.getStaticStr("NoCommand"), Luwrain.MessageType.ERROR);
            }
            return;
        }
        if (!this.commands.run(cmdName.trim())) {
            this.message(this.i18n.getStaticStr("NoCommand"), Luwrain.MessageType.ERROR);
        }
    }

    private boolean runAppCommand(String command) {
        NullCheck.notEmpty((Object)command, (String)"command");
        if (!command.startsWith("app ")) {
            return false;
        }
        String params = command.substring("app ".length());
        String shortcut = null;
        ArrayList<String> args = new ArrayList<String>();
        for (String s : params.split(" ", -1)) {
            if (s.trim().isEmpty()) continue;
            if (shortcut == null) {
                shortcut = s.trim();
                continue;
            }
            args.add(s.trim());
        }
        if (shortcut == null) {
            return false;
        }
        this.launchApp(shortcut, args.toArray(new String[args.size()]));
        return true;
    }

    private void init() {
        this.extensions.load(ext -> this.interfaces.requestNew(ext), this.classLoader);
        this.initObjects();
        for (ScriptFile f : this.extensions.getScriptFiles("core")) {
            try {
                this.loadScript(f);
            }
            catch (ExtensionException e) {
                Core.error(e, "unable to load script " + f.toString());
            }
        }
        this.initI18n();
        this.speech.init();
        this.globalKeys.load(this.os);
        this.fileTypes.load(this.configs);
        this.loadPlayer();
        this.loadDesktop();
        CommonSettings sett = this.configs.load(CommonSettings.class);
        if (sett == null) {
            this.commonSett = CommonSettings.createInitial(this.extensions.loadFromExtensions(Starter.class));
            this.configs.save(this.commonSett);
        } else {
            this.commonSett = sett;
        }
    }

    String loadScript(ScriptSource script) throws ExtensionException {
        Objects.requireNonNull(script, "script can't be null");
        this.mainCoreThreadOnly();
        ScriptExtension ext = new ScriptExtension(script.toString()){

            @Override
            public void launchApp(Application app) {
                Objects.requireNonNull(app, "app can't be null");
                Core.this.launchApp(app);
            }
        };
        ext.init(this.interfaces.requestNew(ext));
        try {
            ext.getScriptCore().load(script);
        }
        catch (Throwable e) {
            this.interfaces.release(ext.getLuwrainObj());
            throw new ExtensionException(e);
        }
        ExtensionsManager.Entry entry = new ExtensionsManager.Entry(ext, ext.getLuwrainObj());
        this.extensions.extensions.add(entry);
        this.objRegistry.takeObjects(ext, entry.extObjects);
        for (Command c : ext.getCommands(ext.getLuwrainObj())) {
            this.commands.add(ext.getLuwrainObj(), c);
        }
        return entry.id;
    }

    private void initObjects() {
        for (Command sc : Commands.getCommands(this, this.conversations)) {
            this.commands.add(this.luwrain, sc);
        }
        for (Command sc : Commands.getNonStandaloneCommands(this, this.conversations)) {
            this.commands.add(this.luwrain, sc);
        }
        UniRefProc[] standardUniRefProcs = UniRefProcs.createStandardUniRefProcs(this.luwrain);
        for (UniRefProc proc : standardUniRefProcs) {
            this.uniRefProcs.add(this.luwrain, proc);
        }
        for (ExtensionsManager.Entry e : this.extensions.extensions) {
            this.objRegistry.takeObjects(e.ext, e.extObjects);
            for (UniRefProc p : e.ext.getUniRefProcs(e.luwrain)) {
                if (this.uniRefProcs.add(this.luwrain, p)) continue;
                Core.warn("the uniRefProc '" + p.getUniRefType() + "' of extension " + e.getClass().getName() + " has been refused by  the uniRefProcs manager to be registered");
            }
            for (Command c : e.ext.getCommands(e.luwrain)) {
                if (this.commands.add(this.luwrain, c)) continue;
                Core.warn("command '" + c.getName() + "' of extension " + e.getClass().getName() + " has been refused by  the commands manager to be registered");
            }
        }
    }

    private void initI18n() {
        for (ExtensionsManager.Entry e : this.extensions.extensions) {
            try {
                e.ext.i18nExtension(e.luwrain, this.i18n);
            }
            catch (Exception ex) {
                Core.error(ex, "extension " + e.getClass().getName() + " thrown an exception on i18n");
            }
        }
        if (!this.i18n.selectLang(this.lang)) {
            Log.fatal("core", "unable to choose matching language for i18n, requested language is '" + this.lang + "'");
            return;
        }
    }

    private void loadPlayer() {
        List<Factory> factories = this.extensions.load(Factory.class);
        for (Factory f : ServiceLoader.load(Factory.class)) {
            factories.add(f);
        }
        if (factories.isEmpty()) {
            LOGGER.warn("No loaded player factories, no player");
            this.player = null;
            return;
        }
        LOGGER.trace("Loaded player factory class is " + factories.get(0).getClass().getName());
        try {
            Factory.Params params = new Factory.Params();
            params.luwrain = this.luwrain;
            this.player = factories.get(0).newPlayer(params);
            if (this.player == null) {
                LOGGER.error("Player factory of the class " + factories.get(0).getClass().getName() + " has returned null, no player");
                return;
            }
            LOGGER.info("Loaded player class is " + this.player.getClass().getName());
        }
        catch (Throwable ex) {
            LOGGER.error("Unable to load the player implementation", ex);
            this.player = null;
            return;
        }
    }

    private void loadDesktop() {
        ArrayList<Desktop> desktops = new ArrayList<Desktop>();
        for (Desktop d : ServiceLoader.load(Desktop.class)) {
            desktops.add(d);
        }
        if (desktops.isEmpty()) {
            throw new RuntimeException("No desktop providers");
        }
        this.desktop = (Application)desktops.get(0);
        LOGGER.trace("Loaded desktop class is " + this.desktop.getClass().getName());
        InitResult initRes = this.desktop.onLaunchApp(this.interfaces.requestNew(this.desktop));
        if (!initRes.isOk()) {
            LOGGER.error("Unable to init the desktop app: " + initRes.toString());
            throw new RuntimeException("Unable to init the desktop app of the class " + this.desktop.getClass().getName());
        }
        this.apps.setDesktopApp(this.desktop);
    }

    void quit() {
        this.mainStopCondition.stop();
    }

    void launchApp(String shortcutName, String[] args) {
        NullCheck.notEmpty((Object)shortcutName, (String)"shortcutName");
        NullCheck.notNullItems((Object[])args, (String)"args");
        Core.debug("launching the app '" + shortcutName + "' with " + args.length + " argument(s)");
        this.mainCoreThreadOnly();
        for (int i = 0; i < args.length; ++i) {
            Core.debug("args[" + i + "]: " + args[i]);
        }
        Shortcut shortcut = this.objRegistry.getShortcut(shortcutName);
        if (shortcut == null) {
            this.message("\u041d\u0435\u0442 \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u044f \u0441 \u0438\u043c\u0435\u043d\u0435\u043c " + shortcutName, Luwrain.MessageType.ERROR);
            return;
        }
        AtomicReference appRef = new AtomicReference();
        this.unsafeAreaOperation(() -> appRef.set(shortcut.prepareApp(args)));
        Application[] app = (Application[])appRef.get();
        if (app == null) {
            this.message("\u041f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u0435 " + shortcutName + " \u043d\u0435 \u0433\u043e\u0442\u043e\u0432\u043e \u043a \u0437\u0430\u043f\u0443\u0441\u043a\u0443", Luwrain.MessageType.ERROR);
            return;
        }
        for (Application a : app) {
            if (a != null) continue;
            this.message("\u041f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u0435 " + shortcutName + " \u043d\u0435 \u0433\u043e\u0442\u043e\u0432\u043e \u043a \u0437\u0430\u043f\u0443\u0441\u043a\u0443", Luwrain.MessageType.ERROR);
            return;
        }
        this.soundManager.stopStartingMode();
        for (Application a : app) {
            this.launchApp(a);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    void launchApp(Application app) {
        block23: {
            Luwrain o;
            NullCheck.notNull((Object)app, (String)"app");
            this.mainCoreThreadOnly();
            if (app instanceof MonoApp) {
                for (Application a : this.apps.getLaunchedApps()) {
                    if (!(a instanceof MonoApp) || !a.getClass().equals(app.getClass())) continue;
                    MonoApp ma = (MonoApp)a;
                    AtomicReference ref = new AtomicReference();
                    this.unsafeAreaOperation(() -> {
                        MonoApp.Result value = ma.onMonoAppSecondInstance(app);
                        if (value != null) {
                            ref.set(value);
                        }
                    });
                    if (ref.get() == null) continue;
                    MonoApp.Result res = (MonoApp.Result)((Object)ref.get());
                    switch (res) {
                        case SECOND_INSTANCE_PERMITTED: {
                            break;
                        }
                        case BRING_FOREGROUND: {
                            this.apps.setActiveApp(a);
                            this.onNewAreasLayout();
                            this.announcement = Base.AnnouncementType.APP;
                            return;
                        }
                    }
                }
            }
            Luwrain toRelease = o = this.interfaces.requestNew(app);
            try {
                InitResult initResult;
                try {
                    initResult = app.onLaunchApp(o);
                }
                catch (OutOfMemoryError e) {
                    Core.error("no enough memory to launch the app of the class " + app.getClass().getName());
                    this.message(this.i18n.getStaticStr("AppLaunchNoEnoughMemory"), Luwrain.MessageType.ERROR);
                    if (toRelease != null) {
                        this.interfaces.release(toRelease);
                    }
                    return;
                }
                catch (Throwable e) {
                    Core.error(e, "application " + app.getClass().getName() + " has thrown an exception on onLaunch()");
                    this.launchAppCrash(new App(e, app, null));
                    if (toRelease != null) {
                        this.interfaces.release(toRelease);
                    }
                    return;
                }
                if (initResult.getType() != InitResult.Type.OK) {
                    this.launchAppCrash(new App(new InitResultException(initResult), app, null));
                    return;
                }
                if (initResult == null || !initResult.isOk()) {
                    return;
                }
                if (!this.apps.newApp(app)) {
                    return;
                }
                toRelease = null;
                break block23;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                if (toRelease != null) {
                    this.interfaces.release(toRelease);
                }
            }
        }
        this.soundManager.stopStartingMode();
        this.onNewAreasLayout();
        this.announcement = Base.AnnouncementType.APP;
    }

    void launchAppCrash(Luwrain instance, Throwable e) {
        NullCheck.notNull((Object)instance, (String)"instance");
        NullCheck.notNull((Object)e, (String)"e");
        Application app = this.interfaces.findApp(instance);
        if (app != null) {
            this.launchAppCrash(new App(e, app, null));
        }
    }

    void launchAppCrash(App app) {
        InitResult initResult;
        NullCheck.notNull((Object)app, (String)"app");
        Luwrain o = this.interfaces.requestNew(app);
        try {
            initResult = app.onLaunchApp(o);
        }
        catch (OutOfMemoryError ee) {
            this.interfaces.release(o);
            return;
        }
        if (initResult == null || !initResult.isOk()) {
            this.interfaces.release(o);
            return;
        }
        if (!this.apps.newApp(app)) {
            this.interfaces.release(o);
            return;
        }
        this.onNewAreasLayout();
        this.announcement = Base.AnnouncementType.APP;
    }

    void closeApp(Luwrain instance) {
        NullCheck.notNull((Object)instance, (String)"instance");
        this.mainCoreThreadOnly();
        if (instance == this.luwrain) {
            throw new IllegalArgumentException("Trying to close an application through the special interface object");
        }
        Application app = this.interfaces.findApp(instance);
        if (app == null) {
            throw new IllegalArgumentException("Trying to close an application through an illegal interface object");
        }
        if (this.desktop != null && app == this.desktop) {
            this.quit();
            return;
        }
        if (this.apps.hasPopupOfApp(app)) {
            this.message(this.i18n.getStaticStr("AppCloseHasPopup"), Luwrain.MessageType.ERROR);
            return;
        }
        try {
            app.onAppClose();
        }
        catch (Throwable e) {
            Core.error(e, "closing the app " + app.getClass().getName());
        }
        this.apps.removeApp(app);
        this.interfaces.release(instance);
        this.onNewAreasLayout();
        this.setAppIntroduction();
    }

    void onSwitchNextAppCommand() {
        this.mainCoreThreadOnly();
        this.apps.switchNextApp();
        this.onNewAreasLayout();
        this.announcement = Base.AnnouncementType.APP;
    }

    void announceActiveAreaIface() {
        this.announceActiveArea();
    }

    void onNewAreaLayout(Luwrain instance) {
        NullCheck.notNull((Object)instance, (String)"instance");
        this.mainCoreThreadOnly();
        Application app = this.interfaces.findApp(instance);
        if (app == null) {
            Core.warn("trying to update area layout with the unknown app instance");
            return;
        }
        this.apps.updateAppAreaLayout(app);
        this.onNewAreasLayout();
    }

    void onSwitchNextAreaCommand() {
        this.mainCoreThreadOnly();
        this.tiles.activateNextArea();
        this.onNewAreasLayout();
        this.announceActiveArea();
    }

    void popup(Application app, Area area, Popup.Position pos, Base.StopCondition stopCondition, Set<Popup.Flags> flags) {
        NullCheck.notNull((Object)area, (String)"area");
        NullCheck.notNull((Object)((Object)pos), (String)"pos");
        NullCheck.notNull((Object)stopCondition, (String)"stopCondition");
        this.mainCoreThreadOnly();
        if (flags.contains((Object)Popup.Flags.NO_MULTIPLE_COPIES)) {
            this.apps.onNewPopupOpening(app, area.getClass());
        }
        Base.PopupStopCondition popupStopCondition = new Base.PopupStopCondition(this.mainStopCondition, stopCondition);
        this.apps.addNewPopup(app, area, pos, popupStopCondition, flags);
        this.tiles.setPopupActive();
        this.onNewAreasLayout();
        this.announceActiveArea();
        this.eventLoop(popupStopCondition);
        this.apps.closeLastPopup();
        this.onNewAreasLayout();
        this.setAreaIntroduction();
    }

    int getAreaVisibleHeightIface(Luwrain instance, Area area) {
        Application app;
        NullCheck.notNull((Object)area, (String)"area");
        this.mainCoreThreadOnly();
        Area effectiveArea = null;
        if (instance != null && (app = this.interfaces.findApp(instance)) != null) {
            if (!this.apps.isAppLaunched(app)) {
                return -1;
            }
            effectiveArea = this.apps.getCorrespondingEffectiveArea(app, area);
        }
        if (effectiveArea == null) {
            effectiveArea = this.apps.getCorrespondingEffectiveArea(area);
        }
        if (effectiveArea == null) {
            return -1;
        }
        return this.windowManager.getAreaVisibleHeight(effectiveArea);
    }

    int getScreenWidthIface() {
        this.mainCoreThreadOnly();
        return this.interaction.getWidthInCharacters();
    }

    int getScreenHeightIface() {
        this.mainCoreThreadOnly();
        return this.interaction.getHeightInCharacters();
    }

    int getAreaVisibleWidthIface(Luwrain instance, Area area) {
        Application app;
        NullCheck.notNull((Object)area, (String)"area");
        this.mainCoreThreadOnly();
        Area effectiveArea = null;
        if (instance != null && (app = this.interfaces.findApp(instance)) != null) {
            if (!this.apps.isAppLaunched(app)) {
                return -1;
            }
            effectiveArea = this.apps.getCorrespondingEffectiveArea(app, area);
        }
        if (effectiveArea == null) {
            effectiveArea = this.apps.getCorrespondingEffectiveArea(area);
        }
        if (effectiveArea == null) {
            return -1;
        }
        return this.windowManager.getAreaVisibleWidth(effectiveArea);
    }

    @Override
    void message(String text, Luwrain.MessageType messageType) {
        NullCheck.notNull((Object)text, (String)"text");
        NullCheck.notNull((Object)((Object)messageType), (String)"messageType");
        this.mainCoreThreadOnly();
        switch (messageType) {
            case ERROR: {
                this.message(text, Sounds.ERROR);
                break;
            }
            case OK: {
                this.message(text, Sounds.OK);
                break;
            }
            case DONE: {
                this.message(text, Sounds.DONE);
                break;
            }
            case ANNOUNCEMENT: {
                this.message(text, Sounds.ANNOUNCEMENT);
                break;
            }
            case ALERT: {
                this.message(text, Sounds.ALERT);
                break;
            }
            case UNAVAILABLE: {
                this.message(text, Sounds.BLOCKED);
                break;
            }
            case NONE: {
                this.message(text, (Sounds)null);
                break;
            }
            default: {
                this.message(text, Sounds.MESSAGE);
            }
        }
    }

    void message(String text, Sounds sound) {
        this.mainCoreThreadOnly();
        if (text == null || text.trim().isEmpty()) {
            return;
        }
        this.announcement = null;
        if (sound != null) {
            this.soundManager.playIcon(sound);
        }
        this.speech.speak(this.i18n.getSpeakableText(text, Luwrain.SpeakableTextType.NATURAL), -25, 0);
        this.interaction.startDrawSession();
        this.interaction.clearRect(0, this.interaction.getHeightInCharacters() - 1, this.interaction.getWidthInCharacters() - 1, this.interaction.getHeightInCharacters() - 1);
        this.interaction.drawText(0, this.interaction.getHeightInCharacters() - 1, text, true);
        this.interaction.endDrawSession();
    }

    void fontSizeInc() {
        this.mainCoreThreadOnly();
        this.interaction.setDesirableFontSize(this.interaction.getFontSize() + 5);
        this.windowManager.redraw();
        this.apps.sendBroadcastEvent(new SystemEvent(SystemEvent.Type.BROADCAST, SystemEvent.Code.FONT_SIZE_CHANGED));
        this.message(this.i18n.getStaticStr("FontSize") + " " + this.interaction.getFontSize(), Luwrain.MessageType.REGULAR);
    }

    void fontSizeDec() {
        this.mainCoreThreadOnly();
        if (this.interaction.getFontSize() < 15) {
            return;
        }
        this.interaction.setDesirableFontSize(this.interaction.getFontSize() - 5);
        this.windowManager.redraw();
        this.apps.sendBroadcastEvent(new SystemEvent(SystemEvent.Type.BROADCAST, SystemEvent.Code.FONT_SIZE_CHANGED));
        this.message(this.i18n.getStaticStr("FontSize") + " " + this.interaction.getFontSize(), Luwrain.MessageType.REGULAR);
    }

    boolean runCommand(String command) {
        NullCheck.notNull((Object)command, (String)"command");
        this.mainCoreThreadOnly();
        if (command.trim().isEmpty()) {
            return false;
        }
        return this.commands.run(command.trim());
    }

    void startAreaListening() {
        Area activeArea = this.getActiveArea(true);
        if (activeArea == null) {
            return;
        }
        this.stopAreaListening();
        this.speech.silence();
        this.listening = null;
        AtomicBoolean res = new AtomicBoolean();
        this.unsafeAreaOperation(() -> res.set(this.listening.start()));
        if (res.get()) {
            this.eventNotProcessedMessage();
        }
    }

    void stopAreaListening() {
        if (this.listening == null) {
            return;
        }
        this.listening.cancel();
        this.listening = null;
    }
}

