/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.core;

import org.luwrain.core.NullCheck;

public final class ContentTypes {
    public static final String UNKNOWN = "content/unknown";
    private static final String[] DATA_BINARY = new String[]{"application/octet-stream"};
    public static final String DATA_BINARY_DEFAULT = DATA_BINARY[0];
    private static final String[] TEXT_PLAIN = new String[]{"text/plain"};
    public static final String TEXT_PLAIN_DEFAULT = TEXT_PLAIN[0];
    private static final String[] TEXT_HTML = new String[]{"text/html"};
    public static final String TEXT_HTML_DEFAULT = "text/html";
    private static final String[] APP_PDF = new String[]{"application/pdf"};
    public static final String APP_PDF_DEFAULT = "application/pdf";
    private static final String[] APP_DOC = new String[]{"application/msword"};
    public static final String APP_DOC_DEFAULT = "application/msword";
    private static final String[] APP_DOCX = new String[]{"application/vnd.openxmlformats-officedocument.wordprocessingml.document"};
    public static final String APP_DOCX_DEFAULT = "application/vnd.openxmlformats-officedocument.wordprocessingml.document";
    private static final String[] APP_XLSX = new String[]{"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"};
    public static final String APP_XLSX_DEFAULT = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
    public static final String[] SOUND_WAVE = new String[]{"audio/vnd.wave"};
    public static final String SOUND_WAVE_DEFAULT = SOUND_WAVE[0];
    public static final String[] SOUND_MP3 = new String[]{"audio/mpeg", "audio/MPA", "audio/mpa-robust"};
    public static final String SOUND_MP3_DEFAULT = SOUND_MP3[0];

    public static boolean isUnknown(String value) {
        NullCheck.notNull((Object)value, (String)"value");
        return value.trim().toLowerCase().equals(UNKNOWN.trim().toLowerCase());
    }

    public static String[] getAppPdf() {
        return (String[])APP_PDF.clone();
    }

    public static boolean isAppPdf(String value) {
        NullCheck.notEmpty((Object)value, (String)"value");
        String v = value.trim().toLowerCase();
        for (String s : APP_PDF) {
            if (!s.trim().toLowerCase().equals(v)) continue;
            return true;
        }
        return false;
    }

    public static String[] getAppDoc() {
        return (String[])APP_DOC.clone();
    }

    public static boolean isAppDoc(String value) {
        NullCheck.notNull((Object)value, (String)"value");
        String v = value.trim().toLowerCase();
        for (String s : APP_DOC) {
            if (!s.trim().toLowerCase().equals(v)) continue;
            return true;
        }
        return false;
    }

    public static String[] getAppDocX() {
        return (String[])APP_DOCX.clone();
    }

    public static boolean isAppDocX(String value) {
        NullCheck.notNull((Object)value, (String)"value");
        String v = value.trim().toLowerCase();
        for (String s : APP_DOCX) {
            if (!s.trim().toLowerCase().equals(v)) continue;
            return true;
        }
        return false;
    }

    public static String[] getAppXlsX() {
        return (String[])APP_XLSX.clone();
    }

    public static boolean isAppXlsX(String value) {
        NullCheck.notNull((Object)value, (String)"value");
        String v = value.trim().toLowerCase();
        for (String s : APP_XLSX) {
            if (!s.trim().toLowerCase().equals(v)) continue;
            return true;
        }
        return false;
    }

    public static enum ExpectedType {
        ANY,
        AUDIO,
        TEXT;

    }
}

