/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.luwrain.core.Command;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;

final class CommandManager {
    private final Map<String, Entry> commands = new HashMap<String, Entry>();

    CommandManager() {
    }

    boolean add(Luwrain luwrain, Command command) {
        NullCheck.notNull((Object)luwrain, (String)"luwrain");
        NullCheck.notNull((Object)command, (String)"command");
        String name = command.getName();
        if (name == null || name.trim().isEmpty()) {
            return false;
        }
        if (this.commands.containsKey(name)) {
            return false;
        }
        this.commands.put(name, new Entry(luwrain, name, command));
        return true;
    }

    boolean run(String name) {
        NullCheck.notEmpty((Object)name, (String)"name");
        if (!this.commands.containsKey(name)) {
            return false;
        }
        Entry entry = this.commands.get(name);
        try {
            entry.command.onCommand(entry.luwrain);
        }
        catch (Throwable e) {
            entry.luwrain.crash(e);
        }
        return true;
    }

    String[] getCommandNames() {
        ArrayList<String> res = new ArrayList<String>();
        for (Map.Entry<String, Entry> e : this.commands.entrySet()) {
            res.add(e.getKey());
        }
        Object[] str = res.toArray(new String[res.size()]);
        Arrays.sort(str);
        return str;
    }

    void deleteByInstance(Luwrain luwrain) {
        NullCheck.notNull((Object)luwrain, (String)"luwrain");
        ArrayList<String> deleting = new ArrayList<String>();
        for (Map.Entry<String, Entry> e : this.commands.entrySet()) {
            if (e.getValue().luwrain != luwrain) continue;
            deleting.add(e.getKey());
        }
        for (String s : deleting) {
            this.commands.remove(s);
        }
    }

    private static final class Entry {
        final Luwrain luwrain;
        final String name;
        final Command command;

        Entry(Luwrain luwrain, String name, Command command) {
            NullCheck.notNull((Object)luwrain, (String)"luwrain ");
            NullCheck.notEmpty((Object)name, (String)"name");
            NullCheck.notNull((Object)command, (String)"command");
            this.luwrain = luwrain;
            this.name = name;
            this.command = command;
        }
    }
}

