/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.core;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.luwrain.core.Args;
import org.luwrain.core.BrailleImpl;
import org.luwrain.core.Clipboard;
import org.luwrain.core.CommandManager;
import org.luwrain.core.Config;
import org.luwrain.core.Configs;
import org.luwrain.core.Event;
import org.luwrain.core.EventConsumer;
import org.luwrain.core.EventQueue;
import org.luwrain.core.EventResponse;
import org.luwrain.core.ExtensionsManager;
import org.luwrain.core.FileContentType;
import org.luwrain.core.FileTypes;
import org.luwrain.core.HelpSections;
import org.luwrain.core.InterfaceManager;
import org.luwrain.core.JobsManager;
import org.luwrain.core.Log;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;
import org.luwrain.core.ObjRegistry;
import org.luwrain.core.Sounds;
import org.luwrain.core.Speech;
import org.luwrain.core.TempFiles;
import org.luwrain.core.WorkersTracking;
import org.luwrain.core.sound.Manager;
import org.luwrain.core.speech.SpeakingText;
import org.luwrain.i18n.I18nImpl;

abstract class Base
implements EventConsumer {
    static final Logger LOGGER = LogManager.getLogger();
    static final String LOG_COMPONENT = "core";
    static final String PROP_ICONS_VOLUME = "luwrain.sounds.iconsvol";
    final Config conf;
    final Args args;
    final Configs configs;
    final Luwrain luwrain;
    final HelpSections helpSects;
    final String lang;
    private final Thread mainCoreThread;
    final InterfaceManager interfaces = new InterfaceManager(this);
    final ExtensionsManager extensions = new ExtensionsManager(this, this.interfaces);
    final ObjRegistry objRegistry = new ObjRegistry();
    final TempFiles tempFiles = new TempFiles();
    final CommandManager commands = new CommandManager();
    final EventQueue eventQueue = new EventQueue();
    final MainStopCondition mainStopCondition = new MainStopCondition();
    private EventResponse eventResponse = null;
    final WorkersTracking workers = new WorkersTracking();
    final JobsManager jobs;
    final I18nImpl i18n;
    final Speech speech;
    final SpeakingText speakingText;
    final BrailleImpl braille;
    final Manager soundManager;
    final FileTypes fileTypes;
    final FileContentType contentTypes;
    private final Clipboard clipboard;
    AnnouncementType announcement;

    Base(Config conf) {
        this.jobs = new JobsManager(this.interfaces.systemObj, this.extensions);
        this.i18n = new I18nImpl();
        this.speakingText = new SpeakingText(this.extensions);
        this.braille = new BrailleImpl();
        this.fileTypes = new FileTypes();
        this.contentTypes = new FileContentType();
        this.clipboard = new Clipboard();
        this.announcement = null;
        this.conf = Objects.requireNonNull(conf, "conf can't be null");
        this.args = Objects.requireNonNull(conf.getArgs(), "args can't be null");
        this.configs = Objects.requireNonNull(conf.getConfigs(), "configs can't be null");
        this.speech = new Speech(this.args, this.configs, this.extensions);
        this.luwrain = this.interfaces.systemObj;
        this.lang = conf.getLang();
        this.helpSects = new HelpSections(this.configs);
        this.soundManager = new Manager(this.objRegistry, this.luwrain, this.configs, conf.getSoundsDir().toPath());
        this.mainCoreThread = Thread.currentThread();
    }

    protected abstract void onEvent(Event var1);

    protected abstract void processEventResponse(EventResponse var1);

    abstract void message(String var1, Luwrain.MessageType var2);

    protected abstract void announce(StopCondition var1);

    protected void eventLoop(StopCondition stopCondition) {
        NullCheck.notNull((Object)stopCondition, (String)"stopCondition");
        while (stopCondition.continueEventLoop()) {
            try {
                this.announcement = null;
                this.eventResponse = null;
                Event event = this.eventQueue.pickEvent();
                if (event == null) continue;
                this.onEvent(event);
                event.markAsProcessed();
                if (this.eventResponse != null) {
                    this.processEventResponse(this.eventResponse);
                    this.eventResponse = null;
                    continue;
                }
                this.announce(stopCondition);
            }
            catch (Throwable e) {
                Base.error(e, "event processing failure");
            }
        }
    }

    @Override
    public void enqueueEvent(Event e) {
        this.eventQueue.putEvent(e);
    }

    protected void noAppsMessage() {
        this.speech.silence();
        this.soundManager.playIcon(Sounds.NO_APPLICATIONS);
        this.speech.speak(this.i18n.getStaticStr("NoLaunchedApps"), 0, 0);
    }

    protected void areaInaccessibleMessage() {
        this.speech.silence();
        this.soundManager.playIcon(Sounds.INACCESSIBLE);
    }

    void eventNotProcessedMessage() {
        this.speech.silence();
        this.soundManager.playIcon(Sounds.INACCESSIBLE);
    }

    protected void printMemInfo() {
        Runtime runtime = Runtime.getRuntime();
        NumberFormat format = NumberFormat.getInstance();
        long maxMemory = runtime.maxMemory();
        long allocatedMemory = runtime.totalMemory();
        long freeMemory = runtime.freeMemory();
        Log.debug(LOG_COMPONENT, "Memory usage information:");
        Log.debug(LOG_COMPONENT, "free memory: " + format.format(freeMemory / 0x100000L) + "M");
        Log.debug(LOG_COMPONENT, "allocated memory: " + format.format(allocatedMemory / 1046576L) + "M");
        Log.debug(LOG_COMPONENT, "max memory: " + format.format(maxMemory / 0x100000L) + "M");
    }

    public void setAreaIntroduction() {
        this.announcement = AnnouncementType.AREA;
    }

    protected void setAppIntroduction() {
        this.announcement = AnnouncementType.APP;
    }

    String getLang() {
        return this.lang;
    }

    Clipboard getClipboard() {
        return this.clipboard;
    }

    void setEventResponse(EventResponse eventResponse) {
        NullCheck.notNull((Object)eventResponse, (String)"eventResponse");
        this.eventResponse = eventResponse;
    }

    boolean isMainCoreThread() {
        return Thread.currentThread() == this.mainCoreThread;
    }

    void mainCoreThreadOnly() {
        if (!this.isMainCoreThread()) {
            throw new RuntimeException("Not in the main thread of LUWRAIN core (current thread is '" + Thread.currentThread().getName() + "'");
        }
    }

    File[] getInstalledPacksDirs() {
        File packsDir = this.conf.getPacksDir();
        if (!packsDir.exists() || !packsDir.isDirectory()) {
            return new File[0];
        }
        File[] files = packsDir.listFiles();
        if (files == null) {
            return new File[0];
        }
        ArrayList<File> res = new ArrayList<File>();
        for (File f : files) {
            if (f == null || !f.exists() || !f.isDirectory()) continue;
            res.add(f);
        }
        return res.toArray(new File[res.size()]);
    }

    boolean unloadDynamicExtension(String extId) {
        NullCheck.notEmpty((Object)extId, (String)"extId");
        return true;
    }

    void unsafeOperation(Runnable runnable) {
        NullCheck.notNull((Object)runnable, (String)"runnable");
        this.unsafeAreaOperation(runnable);
    }

    void unsafeAreaOperation(Runnable runnable) {
        NullCheck.notNull((Object)runnable, (String)"runnable");
        try {
            runnable.run();
        }
        catch (Throwable e) {
            this.luwrain.message(e.getClass().getName() + ":" + e.getMessage(), Luwrain.MessageType.ERROR);
            Base.error(e, "unexpected exception in apps");
        }
    }

    static void fatal(String msg) {
        Log.debug(LOG_COMPONENT, msg);
    }

    static void error(String msg) {
        System.err.println("ERROR: " + msg);
        Log.error(LOG_COMPONENT, msg);
    }

    static void error(Throwable e, String comment) {
        Log.error(LOG_COMPONENT, "Exception " + e.getClass().getName());
        if (e.getMessage() != null && !e.getMessage().isEmpty()) {
            Log.error(LOG_COMPONENT, "Message: " + e.getMessage());
        }
        if (comment != null && !comment.isEmpty()) {
            Log.error(LOG_COMPONENT, "Comment: " + comment);
        }
        StringWriter w = new StringWriter();
        PrintWriter p = new PrintWriter(w);
        e.printStackTrace(p);
        w.flush();
        p.flush();
        for (String s : w.toString().split(System.lineSeparator(), -1)) {
            Log.error(LOG_COMPONENT, s);
        }
        if (comment != null && !comment.isEmpty()) {
            System.err.println("ERROR: " + comment);
            System.err.println("Exception: " + e.getClass().getName());
            if (e.getMessage() != null && !e.getMessage().isEmpty()) {
                System.err.println("Message: " + e.getMessage());
            }
        } else {
            System.err.println("Exception in the LUWRAIN core " + e.getClass().getName());
            if (e.getMessage() != null && !e.getMessage().isEmpty()) {
                System.err.println("Message: " + e.getMessage());
            }
        }
    }

    static void error(Throwable e) {
        Base.error(e, null);
    }

    static void warn(String msg) {
        LOGGER.warn(msg);
    }

    static void info(String msg) {
        LOGGER.info(msg);
    }

    static void debug(String msg) {
        LOGGER.debug(msg);
    }

    protected static final class MainStopCondition
    implements StopCondition {
        private boolean shouldContinue = true;

        protected MainStopCondition() {
        }

        @Override
        public boolean continueEventLoop() {
            return this.shouldContinue;
        }

        void stop() {
            this.shouldContinue = false;
        }
    }

    static enum AnnouncementType {
        AREA,
        APP;

    }

    static interface StopCondition {
        public boolean continueEventLoop();
    }

    static class PopupStopCondition
    implements StopCondition {
        private final StopCondition parentCondition;
        private final StopCondition popupCondition;
        private boolean cancelled = false;

        PopupStopCondition(StopCondition parentCondition, StopCondition popupCondition) {
            NullCheck.notNull((Object)parentCondition, (String)"parentCondition");
            NullCheck.notNull((Object)popupCondition, (String)"popupCondition");
            this.parentCondition = parentCondition;
            this.popupCondition = popupCondition;
        }

        @Override
        public boolean continueEventLoop() {
            return !this.cancelled && this.parentCondition.continueEventLoop() && this.popupCondition.continueEventLoop();
        }

        void cancel() {
            this.cancelled = true;
        }
    }
}

