/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.controls.edit;

import java.util.List;
import java.util.Objects;
import org.luwrain.controls.edit.MultilineCorrector;
import org.luwrain.controls.edit.MultilineEdit;
import org.luwrain.core.HotPointControl;
import org.luwrain.core.MutableLines;
import org.luwrain.util.TextUtils;

public class MultilineTranslator {
    protected final MutableLines lines;
    protected final HotPointControl hotPoint;
    protected final boolean adjustHotPoint;

    MultilineTranslator(MutableLines lines, HotPointControl hotPoint, boolean adjustHotPoint) {
        Objects.requireNonNull(lines, "lines can't be empty");
        Objects.requireNonNull(hotPoint, "hotPoint can't be empty");
        this.lines = lines;
        this.hotPoint = hotPoint;
        this.adjustHotPoint = adjustHotPoint;
    }

    public MultilineTranslator(MutableLines lines, HotPointControl hotPoint) {
        this(lines, hotPoint, true);
    }

    public void change(MultilineCorrector.Change c) {
        Objects.requireNonNull(c, "c can't be empty");
        if (c instanceof MultilineCorrector.DeleteCharChange) {
            MultilineCorrector.DeleteCharChange dc = (MultilineCorrector.DeleteCharChange)c;
            dc.setResult(this.deleteChar(dc.getLine(), dc.getPos()));
            return;
        }
        if (c instanceof MultilineCorrector.InsertCharsChange) {
            MultilineCorrector.InsertCharsChange ic = (MultilineCorrector.InsertCharsChange)c;
            ic.setResult(this.insertChars(ic.getLine(), ic.getPos(), ic.getChars()));
            return;
        }
        if (c instanceof MultilineCorrector.MergeLinesChange) {
            MultilineCorrector.MergeLinesChange ml = (MultilineCorrector.MergeLinesChange)c;
            ml.setResult(this.mergeLines(ml.getLine()));
            return;
        }
        if (c instanceof MultilineCorrector.SplitLineChange) {
            MultilineCorrector.SplitLineChange sl = (MultilineCorrector.SplitLineChange)c;
            sl.setResult(this.splitLine(sl.getLine(), sl.getPos()));
            return;
        }
    }

    private MultilineEdit.ModificationResult deleteChar(int line, int pos) {
        if (pos < 0 || line < 0) {
            throw new IllegalArgumentException("pos (" + pos + ") and line (" + line + ") may not be negative");
        }
        int lineCount = this.lines.getLineCount();
        if (line >= lineCount) {
            throw new IllegalArgumentException("line (" + line + ") must be less than the number of lines (" + lineCount + ")");
        }
        String l = this.lines.getLine(line);
        if (l == null) {
            throw new NullPointerException("null line in the Lines object at position " + line);
        }
        if (pos >= l.length()) {
            throw new IllegalArgumentException("pos (" + pos + ") must be less than the length of the line (" + l.length() + ")");
        }
        try (OperationFinishing op = this.operation(true);){
            this.lines.setLine(line, l.substring(0, pos) + l.substring(pos + 1));
            if (this.hotPoint.getHotPointY() == line && this.hotPoint.getHotPointX() > pos) {
                this.hotPoint.setHotPointX(this.hotPoint.getHotPointX() - 1);
            }
        }
        return new MultilineEdit.ModificationResult(true, l.charAt(pos));
    }

    MultilineEdit.ModificationResult deleteRegion(int fromX, int fromY, int toX, int toY) {
        if (this.lines.getLineCount() < 1 || fromY > toY || fromY == toY && fromX > toX || toY >= this.lines.getLineCount()) {
            return new MultilineEdit.ModificationResult(false);
        }
        if (fromY == toY) {
            int toPos;
            String line = this.lines.getLine(fromY);
            Objects.requireNonNull(line, "line can't be empty");
            if (line.isEmpty()) {
                return new MultilineEdit.ModificationResult(false);
            }
            int fromPos = Math.min(fromX, line.length());
            if (fromPos >= (toPos = Math.min(toX, line.length()))) {
                return new MultilineEdit.ModificationResult(false);
            }
            try (OperationFinishing op = this.operation(true);){
                this.lines.setLine(fromY, line.substring(0, fromPos) + line.substring(toPos));
                if (this.hotPoint.getHotPointY() == fromY) {
                    if (this.hotPoint.getHotPointX() >= fromPos && this.hotPoint.getHotPointX() < toPos) {
                        this.hotPoint.setHotPointX(fromPos);
                    } else if (this.hotPoint.getHotPointX() >= toPos) {
                        this.hotPoint.setHotPointX(this.hotPoint.getHotPointX() - (toPos - fromPos));
                    }
                }
            }
            return new MultilineEdit.ModificationResult(true);
        }
        String firstLine = this.lines.getLine(fromY);
        Objects.requireNonNull(firstLine, "firstLine");
        int fromPos = Math.min(fromX, firstLine.length());
        String endingLine = this.lines.getLine(toY);
        Objects.requireNonNull(endingLine, "endingLine");
        int toPos = Math.min(toX, endingLine.length());
        try (OperationFinishing op = this.operation(true);){
            this.lines.setLine(fromY, firstLine.substring(0, fromPos) + endingLine.substring(toPos));
            for (int i = fromY + 1; i <= toY; ++i) {
                this.lines.removeLine(fromY + 1);
            }
            if (this.hotPoint.getHotPointY() == fromY && this.hotPoint.getHotPointX() >= fromPos || this.hotPoint.getHotPointY() > fromY && this.hotPoint.getHotPointY() < toY || this.hotPoint.getHotPointY() == toY && this.hotPoint.getHotPointX() < toX) {
                this.hotPoint.setHotPointY(fromY);
                this.hotPoint.setHotPointX(fromX);
            } else if (this.hotPoint.getHotPointY() == toY && this.hotPoint.getHotPointX() >= toPos) {
                this.hotPoint.setHotPointY(fromY);
                this.hotPoint.setHotPointX(this.hotPoint.getHotPointX() - toPos + fromPos);
            } else if (this.hotPoint.getHotPointY() > toY) {
                this.hotPoint.setHotPointY(this.hotPoint.getHotPointY() - toY + fromY);
            }
        }
        return new MultilineEdit.ModificationResult(true);
    }

    MultilineEdit.ModificationResult insertRegion(int line, int pos, List<String> text) {
        Objects.requireNonNull(text, "text can't be null");
        this.checkPos(pos, line);
        if (text.isEmpty()) {
            return new MultilineEdit.ModificationResult(true);
        }
        String firstLine = text.get(0);
        String lastLine = text.get(text.size() - 1);
        if (line == 0 && pos == 0 && this.lines.getLineCount() == 0) {
            try (OperationFinishing op = this.operation(false);){
                for (String s : text) {
                    this.lines.addLine(s);
                }
                this.hotPoint.setHotPointX(text.get(text.size() - 1).length());
                this.hotPoint.setHotPointY(this.lines.getLineCount() - 1);
            }
            return new MultilineEdit.ModificationResult(true);
        }
        if (text.size() == 1) {
            String l = this.lines.getLine(line);
            boolean needToMoveHotPoint = this.hotPoint.getHotPointY() == line && pos <= this.hotPoint.getHotPointX();
            try (OperationFinishing op = this.operation(false);){
                this.lines.setLine(line, l.substring(0, pos) + firstLine + l.substring(pos));
                if (needToMoveHotPoint) {
                    this.hotPoint.setHotPointX(this.hotPoint.getHotPointX() + firstLine.length());
                }
            }
            return new MultilineEdit.ModificationResult(true);
        }
        return null;
    }

    private MultilineEdit.ModificationResult insertChars(int line, int pos, String str) {
        Objects.requireNonNull(str, "str");
        this.checkPos(pos, line);
        try (OperationFinishing op = this.operation(false);){
            int count;
            if (pos == 0 && line == 0 && this.lines.getLineCount() == 0) {
                this.lines.addLine("");
            }
            if (line >= (count = this.lines.getLineCount())) {
                throw new IllegalArgumentException("line (" + line + ") must be less then the number of lines (" + count + ")");
            }
            String l = this.lines.getLine(line);
            if (pos > l.length()) {
                throw new IllegalArgumentException("pos (" + pos + ") may not be greater than the length of the line (" + l.length() + ")");
            }
            this.lines.setLine(line, l.substring(0, pos) + str + l.substring(pos));
            if (this.hotPoint.getHotPointY() == line && this.hotPoint.getHotPointX() >= pos) {
                this.hotPoint.setHotPointX(this.hotPoint.getHotPointX() + (str != null ? str.length() : 0));
            }
        }
        if (str.length() == 1 && Character.isWhitespace(str.charAt(0))) {
            String word = this.getWordPriorTo(pos, line);
            if (!word.isEmpty()) {
                return new MultilineEdit.ModificationResult(true, word, str.charAt(0));
            }
            return new MultilineEdit.ModificationResult(true, str.charAt(0));
        }
        if (str.length() == 1) {
            return new MultilineEdit.ModificationResult(true, str.charAt(0));
        }
        return new MultilineEdit.ModificationResult(true, str);
    }

    private MultilineEdit.ModificationResult mergeLines(int firstLine) {
        if (firstLine < 0) {
            throw new IllegalArgumentException("firstLine (" + String.valueOf(firstLine) + ") can't be negative");
        }
        int lineCount = this.lines.getLineCount();
        if (firstLine + 1 >= lineCount) {
            throw new IllegalArgumentException("firstLine (" + String.valueOf(firstLine) + ") + 1 must be less than the number of lines (" + String.valueOf(lineCount) + ")");
        }
        try (OperationFinishing op = this.operation(true);){
            String line = this.lines.getLine(firstLine);
            Objects.requireNonNull(line, "line");
            int origLineLen = line.length();
            this.lines.setLine(firstLine, line + this.lines.getLine(firstLine + 1));
            this.lines.removeLine(firstLine + 1);
            if (this.hotPoint.getHotPointY() == firstLine + 1) {
                this.hotPoint.setHotPointY(this.hotPoint.getHotPointY() - 1);
                this.hotPoint.setHotPointX(this.hotPoint.getHotPointX() + origLineLen);
            } else if (this.hotPoint.getHotPointY() > firstLine + 1) {
                this.hotPoint.setHotPointY(this.hotPoint.getHotPointY() - 1);
            }
        }
        return new MultilineEdit.ModificationResult(true);
    }

    private MultilineEdit.ModificationResult splitLine(int line, int pos) {
        this.checkPos(pos, line);
        try (OperationFinishing op = this.operation(false);){
            int lineCount;
            if (pos == 0 && line == 0 && this.lines.getLineCount() == 0) {
                this.lines.addLine("");
            }
            if (line >= (lineCount = this.lines.getLineCount())) {
                throw new IllegalArgumentException("The index of the line to split (" + String.valueOf(line) + ") must be less than the number of lines (" + String.valueOf(lineCount) + ")");
            }
            String l = this.lines.getLine(line);
            Objects.requireNonNull(l, "l");
            if (pos > l.length()) {
                throw new IllegalArgumentException("pos (" + String.valueOf(pos) + ") can't be greater than the length of the line (" + String.valueOf(l.length()) + ")");
            }
            this.lines.setLine(line, l.substring(0, pos));
            String newLine = l.substring(pos);
            this.lines.insertLine(line + 1, newLine);
            if (this.hotPoint.getHotPointY() == line && this.hotPoint.getHotPointX() >= pos) {
                this.hotPoint.setHotPointY(line + 1);
                this.hotPoint.setHotPointX(this.hotPoint.getHotPointX() - pos);
            } else if (this.hotPoint.getHotPointY() > line) {
                this.hotPoint.setHotPointY(this.hotPoint.getHotPointY() + 1);
            }
            MultilineEdit.ModificationResult modificationResult = new MultilineEdit.ModificationResult(true, newLine);
            return modificationResult;
        }
    }

    protected int getLineCount() {
        int count = this.lines.getLineCount();
        return count > 0 ? count : 1;
    }

    protected String getLine(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("index (" + index + ") may not be negative");
        }
        if (index == 0 && this.lines.getLineCount() == 0) {
            return "";
        }
        return this.lines.getLine(index);
    }

    protected String getWordPriorTo(int pos, int lineIndex) {
        String res = TextUtils.getLastWord(this.getLine(lineIndex), pos);
        if (!res.isEmpty()) {
            return res;
        }
        if (lineIndex == 0) {
            return "";
        }
        for (int i = lineIndex - 1; i >= 0; --i) {
            String line = this.getLine(i);
            res = TextUtils.getLastWord(line, line.length());
            if (res.isEmpty()) continue;
            return res;
        }
        return "";
    }

    protected void checkPos(int pos, int lineIndex) {
        if (pos < 0 || lineIndex < 0) {
            throw new IllegalArgumentException("pos (" + pos + ") and lineIndex (" + lineIndex + ") may not be negative");
        }
        if (this.lines.getLineCount() == 0 && pos == 0 && lineIndex == 0) {
            return;
        }
        if (lineIndex >= this.lines.getLineCount()) {
            throw new IllegalArgumentException("lineIndex (" + lineIndex + ") may not be equal or greater than " + this.lines.getLineCount());
        }
        String line = this.lines.getLine(lineIndex);
        Objects.requireNonNull(line, "line");
        if (pos > line.length()) {
            throw new IllegalArgumentException("pos (" + pos + ") may not be greater than " + line.length());
        }
    }

    protected void beginEditTrans() {
        this.hotPoint.beginHotPointTrans();
    }

    protected void endEditTrans(boolean cleanSingleEmptyLine) {
        if (cleanSingleEmptyLine && this.lines.getLineCount() == 1 && this.lines.getLine(0).isEmpty()) {
            this.lines.removeLine(0);
        }
        this.hotPoint.endHotPointTrans();
    }

    protected OperationFinishing operation(boolean cleanEmptyLine) {
        if (this.adjustHotPoint) {
            if (this.hotPoint.getHotPointX() < 0) {
                this.hotPoint.setHotPointX(0);
            }
            if (this.hotPoint.getHotPointY() < 0) {
                this.hotPoint.setHotPointY(0);
            }
            if (this.hotPoint.getHotPointY() >= this.lines.getLineCount()) {
                if (this.lines.getLineCount() == 0) {
                    this.hotPoint.setHotPointY(0);
                } else {
                    this.hotPoint.setHotPointY(this.lines.getLineCount() - 1);
                }
            }
            if (this.lines.getLineCount() > 0) {
                String line = this.lines.getLine(this.hotPoint.getHotPointY());
                if (line == null) {
                    throw new NullPointerException("The line with the index " + String.valueOf(this.hotPoint.getHotPointY()) + " is null");
                }
                if (this.hotPoint.getHotPointX() > line.length()) {
                    this.hotPoint.setHotPointX(line.length());
                }
            } else if (this.hotPoint.getHotPointX() != 0) {
                this.hotPoint.setHotPointX(0);
            }
        }
        this.beginEditTrans();
        return new OperationFinishing(cleanEmptyLine);
    }

    protected final class OperationFinishing
    implements AutoCloseable {
        final boolean cleanEmptyLine;

        OperationFinishing(boolean cleanEmptyLine) {
            this.cleanEmptyLine = cleanEmptyLine;
        }

        @Override
        public void close() {
            MultilineTranslator.this.endEditTrans(this.cleanEmptyLine);
        }
    }
}

