/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.controls.edit;

import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import org.luwrain.controls.FormArea;
import org.luwrain.controls.edit.EditArea;
import org.luwrain.core.LineMarks;
import org.luwrain.core.MarkedLines;
import org.luwrain.core.NullCheck;

public final class EditUtils {
    public static void blockBounds(EditArea editArea, int lineIndex, BiPredicate<String, LineMarks> pred, BiConsumer<MarkedLines, Integer> accepting) {
        NullCheck.notNull((Object)editArea, (String)"editArea");
        NullCheck.notNull(pred, (String)"pred");
        NullCheck.notNull(accepting, (String)"accepting");
        EditUtils.blockBounds(editArea.getContent(), lineIndex, pred, accepting);
    }

    public static void blockBounds(FormArea formArea, int lineIndex, BiPredicate<String, LineMarks> pred, BiConsumer<MarkedLines, Integer> accepting) {
        NullCheck.notNull((Object)formArea, (String)"formArea");
        NullCheck.notNull(pred, (String)"pred");
        NullCheck.notNull(accepting, (String)"accepting");
        EditUtils.blockBounds(formArea.getMultilineEditContent(), lineIndex, pred, accepting);
    }

    public static void blockBounds(MarkedLines lines, int lineIndex, BiPredicate<String, LineMarks> pred, BiConsumer<MarkedLines, Integer> accepting) {
        NullCheck.notNull((Object)lines, (String)"lines");
        NullCheck.notNull(pred, (String)"pred");
        NullCheck.notNull(accepting, (String)"accepting");
        if (lineIndex < 0) {
            throw new IllegalArgumentException("lineINdex can't be negative");
        }
        if (lineIndex >= lines.getLineCount()) {
            return;
        }
        if (!pred.test(lines.getLine(lineIndex), lines.getLineMarks(lineIndex))) {
            return;
        }
        int toPos = lineIndex;
        for (int fromPos = lineIndex; fromPos > 0 && pred.test(lines.getLine(fromPos - 1), lines.getLineMarks(fromPos - 1)); --fromPos) {
        }
        while (toPos + 1 < lines.getLineCount() && pred.test(lines.getLine(toPos + 1), lines.getLineMarks(toPos + 1))) {
            ++toPos;
        }
        for (int i = fromPos; i <= toPos; ++i) {
            accepting.accept(lines, i);
        }
    }
}

