/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.controls.edit;

import org.luwrain.controls.edit.MultilineEdit;
import org.luwrain.controls.edit.MultilineEditCorrector;
import org.luwrain.controls.edit.MultilineEditModelWrap;
import org.luwrain.core.NullCheck;

public final class EditCorrectors {

    public static class WordWrapCorrector
    extends MultilineEditModelWrap {
        protected final int lineLen;

        public WordWrapCorrector(MultilineEditCorrector basicCorrector, int lineLen) {
            super(basicCorrector);
            if (lineLen < 0) {
                throw new IllegalArgumentException("lineLen can't be negative");
            }
            this.lineLen = lineLen;
        }

        @Override
        public MultilineEdit.ModificationResult putChars(int pos, int lineIndex, String str) {
            NullCheck.notNull((Object)str, (String)"str");
            if (!str.equals(" ") || pos != this.getHotPointX() || lineIndex != this.getHotPointY()) {
                return super.putChars(pos, lineIndex, str);
            }
            String line = this.getLine(lineIndex);
            NullCheck.notNull((Object)line, (String)"line");
            if (line.length() <= this.lineLen || this.getHotPointX() <= this.lineLen) {
                return super.putChars(pos, lineIndex, str);
            }
            int i = -1;
            for (i = this.lineLen; i >= 0 && !Character.isWhitespace(line.charAt(i)); --i) {
            }
            if (i <= 0) {
                return super.putChars(pos, lineIndex, str);
            }
            super.splitLine(i, lineIndex);
            return new MultilineEdit.ModificationResult(true, this.getLine(lineIndex + 1), ' ');
        }
    }

    public static class IndentationCorrector
    extends MultilineEditModelWrap {
        public IndentationCorrector(MultilineEdit.Model basicCorrector) {
            super(basicCorrector);
        }

        @Override
        public MultilineEdit.ModificationResult splitLine(int pos, int lineIndex) {
            MultilineEdit.ModificationResult res = this.wrappedModel.splitLine(pos, lineIndex);
            if (!res.isPerformed()) {
                return res;
            }
            int indent = this.getIndent(lineIndex);
            if (!this.deleteIndent(lineIndex + 1)) {
                return new MultilineEdit.ModificationResult(false);
            }
            if (!this.addIndent(lineIndex + 1, indent)) {
                return new MultilineEdit.ModificationResult(false);
            }
            return res;
        }

        protected int getIndent(int lineIndex) {
            int tabLen = this.getTabLen();
            String line = this.getLine(lineIndex);
            int res = 0;
            for (int i = 0; i < line.length() && Character.isWhitespace(line.charAt(i)); ++i) {
                if (line.charAt(i) == '\t') {
                    res += tabLen;
                    continue;
                }
                ++res;
            }
            return res;
        }

        protected boolean deleteIndent(int lineIndex) {
            int pos;
            String line = this.getLine(lineIndex);
            for (pos = 0; pos < line.length() && Character.isWhitespace(line.charAt(pos)); ++pos) {
            }
            if (pos == 0) {
                return true;
            }
            return this.wrappedModel.deleteRegion(0, lineIndex, pos, lineIndex).isPerformed();
        }

        protected boolean addIndent(int lineIndex, int len) {
            if (len == 0) {
                return true;
            }
            int tabLen = this.getTabLen();
            StringBuilder b = new StringBuilder();
            int tabCount = len / tabLen;
            for (int i = 0; i < tabCount; ++i) {
                b.append('\t');
            }
            int spaceCount = len % tabLen;
            for (int i = 0; i < spaceCount; ++i) {
                b.append(' ');
            }
            return this.wrappedModel.putChars(0, lineIndex, new String(b)).isPerformed();
        }

        protected int getTabLen() {
            return 8;
        }
    }
}

