/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.controls;

import java.util.ArrayList;
import java.util.Arrays;
import org.luwrain.core.MutableLines;
import org.luwrain.core.NullCheck;

public class MutableLinesImpl
extends ArrayList<String>
implements MutableLines {
    public MutableLinesImpl() {
    }

    public MutableLinesImpl(String[] lines) {
        NullCheck.notNullItems((Object[])lines, (String)"lines");
        this.addAll(Arrays.asList(lines));
    }

    @Override
    public void update(MutableLines.Updating updating) {
        NullCheck.notNull((Object)updating, (String)"updating");
        updating.update(this);
    }

    @Override
    public int getLineCount() {
        return this.size();
    }

    @Override
    public String getLine(int index) {
        if (index < 0 || index >= this.size()) {
            return "";
        }
        return (String)this.get(index);
    }

    @Override
    public void setLines(String[] lines) {
        NullCheck.notNullItems((Object[])lines, (String)"lines");
        this.clear();
        this.addAll(Arrays.asList(lines));
    }

    @Override
    public String[] getLines() {
        return this.toArray(new String[this.size()]);
    }

    @Override
    public void setLine(int index, String line) {
        NullCheck.notNull((Object)line, (String)"line");
        if (index < 0) {
            throw new IllegalArgumentException("index (" + String.valueOf(index) + " can't be negative");
        }
        if (index >= this.size()) {
            throw new IllegalArgumentException("index (" + String.valueOf(index) + ") can't be greater or equal to line count (" + String.valueOf(this.size()) + ")");
        }
        this.set(index, line);
    }

    @Override
    public void addLine(String line) {
        NullCheck.notNull((Object)line, (String)"line");
        this.add(line);
    }

    @Override
    public void insertLine(int index, String line) {
        NullCheck.notNull((Object)line, (String)"line");
        if (index < 0 || index > this.size()) {
            throw new IllegalArgumentException("Illegal index value (" + index + ")");
        }
        if (index < this.size()) {
            this.add(index, line);
        } else {
            this.add(line);
        }
    }

    @Override
    public void removeLine(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IllegalArgumentException("Invalid index (" + index + ")");
        }
        this.remove(index);
    }

    public String getWholeText(String lineSep) {
        String s;
        String string = s = lineSep != null ? lineSep : System.lineSeparator();
        if (this.size() == 0) {
            return "";
        }
        if (this.size() == 1) {
            return (String)this.get(0);
        }
        StringBuilder res = new StringBuilder();
        res.append((String)this.get(0));
        for (int i = 1; i < this.size(); ++i) {
            res.append(s).append((String)this.get(i));
        }
        return new String(res);
    }

    public String getWholeText() {
        return this.getWholeText(null);
    }
}

