/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.controls;

import java.io.File;
import java.util.ArrayList;
import org.luwrain.controls.ControlContext;
import org.luwrain.controls.FormArea;
import org.luwrain.controls.MutableMarkedLinesImpl;
import org.luwrain.controls.edit.EditCorrectors;
import org.luwrain.controls.edit.MultilineEdit;
import org.luwrain.controls.edit.MultilineEditCorrector;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;

public class MessageArea
extends FormArea {
    public static final int DEFAULT_MAX_LINE_LEN = 80;
    static final String TO_NAME = "to";
    static final String CC_NAME = "cc";
    static final String SUBJECT_NAME = "subject";
    static final String ATTACHMENT = "attachment";
    protected final MutableMarkedLinesImpl lines;
    protected int attachmentCounter = 0;
    protected final int maxLineLen;

    public MessageArea(Params params) {
        super(params.context, params.name);
        NullCheck.notNull((Object)params, (String)"params");
        NullCheck.notNullItems((Object[])params.text, (String)"params.text");
        NullCheck.notNullItems((Object[])params.attachments, (String)"params.attachments");
        this.maxLineLen = params.maxLineLen;
        this.lines = new MutableMarkedLinesImpl(params.text);
        this.addEdit(TO_NAME, this.context.getI18n().getStaticStr("MessageTo"), params.to);
        this.addEdit(CC_NAME, this.context.getI18n().getStaticStr("MessageCc"), params.cc);
        this.addEdit(SUBJECT_NAME, this.context.getI18n().getStaticStr("MessageSubject"), params.subject);
        this.activateMultilineEdit(this.context.getI18n().getStaticStr("MessageEnterTextBelow"), this.lines, this.createEditParams(), true);
        for (String a : params.attachments) {
            this.addAttachment(new File(a));
        }
    }

    public String getTo() {
        return this.getEnteredText(TO_NAME);
    }

    public void setTo(String value) {
        NullCheck.notNull((Object)value, (String)"value");
        this.setEnteredText(value, "value");
    }

    public void focusTo() {
        this.setHotPoint(0, 0);
    }

    public String getCc() {
        return this.getEnteredText(CC_NAME);
    }

    public void setCc(String value) {
        NullCheck.notNull((Object)value, (String)"value");
        this.setEnteredText(CC_NAME, value);
    }

    public String getSubject() {
        return this.getEnteredText(SUBJECT_NAME);
    }

    public void focusSubject() {
        this.setHotPoint(0, 2);
    }

    public String getText(String lineSeparator) {
        NullCheck.notNull((Object)lineSeparator, (String)"lineSeparator");
        return this.lines.getText(lineSeparator);
    }

    public Attachment getAttachmentByLineIndex(int lineIndex) {
        if (this.getItemTypeOnLine(lineIndex) != FormArea.Type.STATIC) {
            return null;
        }
        Object obj = this.getItemObj(lineIndex);
        if (obj == null || !(obj instanceof Attachment)) {
            return null;
        }
        return (Attachment)obj;
    }

    public Attachment[] getAttachments() {
        ArrayList<Attachment> res = new ArrayList<Attachment>();
        for (int i = 0; i < this.getItemCount(); ++i) {
            Object o;
            if (this.getItemTypeOnLine(i) != FormArea.Type.STATIC || (o = this.getItemObj(i)) == null || !(o instanceof Attachment)) continue;
            res.add((Attachment)o);
        }
        return res.toArray(new Attachment[res.size()]);
    }

    public File[] getAttachmentFiles() {
        Attachment[] attachments = this.getAttachments();
        File[] res = new File[attachments.length];
        for (int i = 0; i < attachments.length; ++i) {
            res[i] = attachments[i].file;
        }
        return res;
    }

    public void addAttachment(File file) {
        NullCheck.notNull((Object)file, (String)"file");
        for (Attachment a : this.getAttachments()) {
            if (!a.file.equals(file)) continue;
            this.context.message("\u0424\u0430\u0439\u043b " + file.getName() + " \u0443\u0436\u0435 \u043f\u0440\u0438\u043a\u0440\u0435\u043f\u043b\u0451\u043d \u043a \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u044e", Luwrain.MessageType.ERROR);
            return;
        }
        Attachment a = new Attachment(ATTACHMENT + this.attachmentCounter, file);
        ++this.attachmentCounter;
        this.addStatic(a.name, this.context.getI18n().getStaticStr("MessageAttachment") + " " + a.file.getName(), a);
    }

    public void removeAttachmentByLineIndex(int lineIndex) {
        this.removeItemOnLine(lineIndex);
    }

    protected MultilineEdit.Params createEditParams() {
        MultilineEdit.Params params = this.createMultilineEditParams(this.context, this.lines);
        if (this.maxLineLen > 0) {
            MultilineEditCorrector corrector = (MultilineEditCorrector)params.model;
            params.model = new EditCorrectors.WordWrapCorrector(corrector, this.maxLineLen);
        }
        return params;
    }

    public static class Params {
        public ControlContext context = null;
        public String name = "";
        public int maxLineLen = 80;
        public String to = "";
        public String cc = "";
        public String subject = "";
        public String[] text = new String[0];
        public String[] attachments = new String[0];
    }

    public static final class Attachment {
        final String name;
        final File file;

        Attachment(String name, File file) {
            NullCheck.notEmpty((Object)name, (String)"name");
            NullCheck.notNull((Object)file, (String)"file");
            this.name = name;
            this.file = file;
        }

        public String getName() {
            return this.name;
        }

        public File getFile() {
            return this.file;
        }
    }
}

