/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.controls;

import java.util.ArrayList;
import org.luwrain.controls.ListArea;
import org.luwrain.controls.ListUtils;
import org.luwrain.core.NullCheck;
import org.luwrain.core.events.InputEvent;
import org.luwrain.core.events.SystemEvent;

public class MarkableListArea
extends ListArea<Object> {
    protected final MarksInfo marksInfo;

    public MarkableListArea(Params params) {
        super(params);
        NullCheck.notNull((Object)params.marksInfo, (String)"params.marksInfo");
        this.marksInfo = params.marksInfo;
    }

    MarksInfo getMarksInfo() {
        return this.marksInfo;
    }

    @Override
    public boolean onInputEvent(InputEvent event) {
        NullCheck.notNull((Object)event, (String)"event");
        if (!event.isSpecial()) {
            switch (event.getChar()) {
                case ' ': {
                    this.regionPoint.reset();
                    this.context.onAreaNewContent(this);
                    return this.onToggleMark();
                }
            }
        }
        return super.onInputEvent(event);
    }

    @Override
    public boolean onSystemEvent(SystemEvent event) {
        NullCheck.notNull((Object)event, (String)"event");
        if (event.getType() != SystemEvent.Type.REGULAR) {
            return super.onSystemEvent(event);
        }
        switch (event.getCode()) {
            case REGION_POINT: {
                this.marksInfo.clearMarks();
                this.context.onAreaNewContent(this);
                return super.onSystemEvent(event);
            }
        }
        return super.onSystemEvent(event);
    }

    protected boolean onToggleMark() {
        Object selected = this.selected();
        if (selected == null) {
            return false;
        }
        boolean newState = this.marksInfo.toggleMark(selected);
        this.context.say(newState ? "\u041e\u0442\u043c\u0435\u0447\u0435\u043d\u043e" : "\u041d\u0435 \u043e\u0442\u043c\u0435\u0447\u0435\u043d\u043e");
        this.context.onAreaNewContent(this);
        return true;
    }

    @Override
    public void refresh() {
        super.refresh();
        ArrayList newItems = new ArrayList();
        int count = this.listModel.getItemCount();
        for (int i = 0; i < count; ++i) {
            Object o = this.listModel.getItem(i);
            if (!this.marksInfo.marked(o)) continue;
            newItems.add(o);
        }
        this.marksInfo.markOnly(newItems.toArray(new Object[newItems.size()]));
    }

    @Override
    public boolean onClipboardCopy(int fromX, int fromY, int toX, int toY, boolean withDeleting) {
        if (this.isEmpty() || withDeleting) {
            return false;
        }
        if (fromX < 0 || toX < 0 || fromX == toX && fromY == toY) {
            Object[] objs = this.marksInfo.getAllMarked();
            if (objs == null || objs.length == 0) {
                return super.onClipboardCopy(fromX, fromY, toX, toY, withDeleting);
            }
            return this.listClipboardSaver.saveToClipboard(this, new ListUtils.ArrayModel(() -> objs), this.listAppearance, 0, objs.length, this.context.getClipboard());
        }
        return super.onClipboardCopy(fromX, fromY, toX, toY, withDeleting);
    }

    public static class Params
    extends ListArea.Params<Object> {
        public MarksInfo marksInfo = null;
    }

    public static interface MarksInfo {
        public boolean marked(Object var1);

        public void mark(Object var1);

        public void unmark(Object var1);

        public boolean toggleMark(Object var1);

        public void markOnly(Object[] var1);

        public void clearMarks();

        public Object[] getAllMarked();
    }
}

