/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.crash;

import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.luwrain.app.base.LayoutBase;
import org.luwrain.app.crash.App;
import org.luwrain.app.crash.CustomMessageException;
import org.luwrain.app.crash.InitResultException;
import org.luwrain.app.crash.Strings;
import org.luwrain.controls.DefaultControlContext;
import org.luwrain.controls.SimpleArea;
import org.luwrain.core.AreaLayout;
import org.luwrain.core.AreaQuery;
import org.luwrain.core.InitResult;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;
import org.luwrain.core.events.InputEvent;
import org.luwrain.core.events.SystemEvent;

final class MainLayout
extends LayoutBase {
    private final App app;
    private final SimpleArea simpleArea;

    MainLayout(final App app) {
        NullCheck.notNull((Object)app, (String)"app");
        this.app = app;
        this.simpleArea = new SimpleArea(new DefaultControlContext(app.getLuwrain()), ((Strings)app.getStrings()).appName()){

            @Override
            public boolean onInputEvent(InputEvent event) {
                NullCheck.notNull((Object)event, (String)"event");
                if (app.onInputEvent(this, event)) {
                    return true;
                }
                return super.onInputEvent(event);
            }

            @Override
            public boolean onSystemEvent(SystemEvent event) {
                NullCheck.notNull((Object)event, (String)"event");
                if (app.onSystemEvent(this, event)) {
                    return true;
                }
                return super.onSystemEvent(event);
            }

            @Override
            public boolean onAreaQuery(AreaQuery query) {
                NullCheck.notNull((Object)query, (String)"query");
                if (app.onAreaQuery(this, query)) {
                    return true;
                }
                return super.onAreaQuery(query);
            }

            @Override
            public void announceLine(int index, String line) {
                NullCheck.notNull((Object)line, (String)"line");
                1.defaultLineAnnouncement(this.context, index, app.getLuwrain().getSpeakableText(line, Luwrain.SpeakableTextType.PROGRAMMING));
            }
        };
        this.fillText();
    }

    private void fillText() {
        InitResultException ex;
        if (this.app.ex instanceof InitResultException && (ex = (InitResultException)this.app.ex).getInitResult().getType() == InitResult.Type.EXCEPTION) {
            this.fillException(ex.getInitResult().getException());
            return;
        }
        if (this.app.ex instanceof CustomMessageException) {
            CustomMessageException c = (CustomMessageException)this.app.ex;
            this.simpleArea.update(lines -> {
                String[] message;
                for (String s : message = c.getCustomMessage()) {
                    lines.addLine(s);
                }
                lines.addLine("");
            });
            return;
        }
        this.fillException(this.app.ex);
    }

    private void fillException(Throwable t) {
        NullCheck.notNull((Object)t, (String)"t");
        this.simpleArea.update(lines -> {
            String[] trace;
            if (t instanceof FileNotFoundException && t.getMessage() != null) {
                lines.addLine("");
                lines.addLine(((Strings)this.app.getStrings()).fileNotFound() + ": " + t.getMessage());
            }
            String[] msg = ((Strings)this.app.getStrings()).intro().split("\\n");
            lines.addLine("");
            for (String s : msg) {
                lines.addLine(s);
            }
            lines.addLine("");
            if (this.app.srcApp != null) {
                lines.addLine(((Strings)this.app.getStrings()).app(this.app.srcApp.getClass().getName()));
            }
            if (this.app.srcArea != null) {
                lines.addLine(((Strings)this.app.getStrings()).area(this.app.srcArea.getClass().getName()));
            }
            if (this.app.srcApp != null || this.app.srcArea != null) {
                lines.addLine("");
            }
            lines.addLine(((Strings)this.app.getStrings()).stackTrace());
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            t.printStackTrace(pw);
            pw.flush();
            sw.flush();
            for (String s : trace = sw.toString().split("\n", -1)) {
                lines.addLine(s);
            }
        });
    }

    AreaLayout getLayout() {
        return new AreaLayout(this.simpleArea);
    }
}

