/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.cpanel;

import org.luwrain.app.cpanel.Actions;
import org.luwrain.app.cpanel.Base;
import org.luwrain.app.cpanel.ControlPanelImpl;
import org.luwrain.app.cpanel.Strings;
import org.luwrain.controls.DefaultControlContext;
import org.luwrain.controls.TreeArea;
import org.luwrain.core.Action;
import org.luwrain.core.Application;
import org.luwrain.core.AreaLayout;
import org.luwrain.core.InitResult;
import org.luwrain.core.Luwrain;
import org.luwrain.core.MonoApp;
import org.luwrain.core.NullCheck;
import org.luwrain.core.events.ActionEvent;
import org.luwrain.core.events.InputEvent;
import org.luwrain.core.events.SystemEvent;
import org.luwrain.cpanel.Factory;
import org.luwrain.cpanel.Section;
import org.luwrain.cpanel.SectionArea;

public class ControlPanelApp
implements Application,
MonoApp,
Actions {
    private Luwrain luwrain;
    private Base base = null;
    private Strings strings;
    private ControlPanelImpl iface;
    private final Factory[] factories;
    private Section currentSection = null;
    private TreeArea sectionsArea;
    private SectionArea currentOptionsArea = null;

    public ControlPanelApp(Factory[] factories) {
        NullCheck.notNullItems((Object[])factories, (String)"factories");
        this.factories = factories;
    }

    @Override
    public InitResult onLaunchApp(Luwrain luwrain) {
        NullCheck.notNull((Object)luwrain, (String)"luwrain");
        Object o = luwrain.i18n().getStrings(Strings.class.getName());
        if (o == null || !(o instanceof Strings)) {
            return new InitResult(InitResult.Type.NO_STRINGS_OBJ, Strings.class.getName());
        }
        this.strings = (Strings)o;
        this.luwrain = luwrain;
        this.base = new Base(luwrain, this.factories);
        this.iface = new ControlPanelImpl(luwrain, this);
        this.createArea();
        return new InitResult();
    }

    private void createArea() {
        TreeArea.Params treeParams = new TreeArea.Params();
        treeParams.context = new DefaultControlContext(this.luwrain);
        treeParams.model = this.base.getTreeModel();
        treeParams.name = this.strings.sectionsAreaName();
        treeParams.clickHandler = (area, obj) -> this.openSection(obj);
        this.sectionsArea = new TreeArea(treeParams){

            @Override
            public boolean onInputEvent(InputEvent event) {
                NullCheck.notNull((Object)event, (String)"event");
                if (event.isSpecial() && !event.isModified()) {
                    switch (event.getSpecial()) {
                        case ESCAPE: {
                            ControlPanelApp.this.closeApp();
                            return true;
                        }
                        case TAB: {
                            return ControlPanelApp.this.gotoOptions();
                        }
                    }
                }
                return super.onInputEvent(event);
            }

            @Override
            public boolean onSystemEvent(SystemEvent event) {
                NullCheck.notNull((Object)event, (String)"event");
                if (event.getType() != SystemEvent.Type.REGULAR) {
                    return super.onSystemEvent(event);
                }
                switch (event.getCode()) {
                    case ACTION: {
                        return ControlPanelApp.this.onTreeAction(event);
                    }
                    case CLOSE: {
                        ControlPanelApp.this.closeApp();
                        return true;
                    }
                }
                return false;
            }

            @Override
            public Action[] getAreaActions() {
                return ControlPanelApp.this.getTreeActions();
            }
        };
    }

    void refreshSectionsTree() {
        this.base.refreshTreeItems();
        this.sectionsArea.refresh();
    }

    private Action[] getTreeActions() {
        Object selected = this.sectionsArea.selected();
        if (selected == null || !(selected instanceof Section)) {
            return new Action[0];
        }
        Section sect = (Section)selected;
        Action[] res = sect.getSectionActions();
        return res != null ? res : new Action[]{};
    }

    private boolean onTreeAction(SystemEvent event) {
        NullCheck.notNull((Object)event, (String)"event");
        Object selected = this.sectionsArea.selected();
        if (selected == null || !(selected instanceof Section)) {
            return false;
        }
        Section sect = (Section)selected;
        return sect.onSectionActionEvent(this.iface, (ActionEvent)event);
    }

    private boolean openSection(Object obj) {
        NullCheck.notNull((Object)obj, (String)"obj");
        if (!(obj instanceof Section)) {
            return false;
        }
        Section sect = (Section)obj;
        SectionArea area = sect.getSectionArea(this.iface);
        if (area == null) {
            return false;
        }
        if (this.currentOptionsArea != null) {
            if (!this.currentOptionsArea.saveSectionData()) {
                return true;
            }
            this.currentOptionsArea = null;
            this.currentSection = null;
        }
        this.currentSection = sect;
        this.currentOptionsArea = area;
        this.luwrain.onNewAreaLayout();
        this.gotoOptions();
        return true;
    }

    void gotoSections() {
        this.luwrain.setActiveArea(this.sectionsArea);
    }

    private boolean gotoOptions() {
        if (this.currentSection == null || this.currentOptionsArea == null) {
            return false;
        }
        this.luwrain.setActiveArea(this.currentOptionsArea);
        return true;
    }

    @Override
    public AreaLayout getAreaLayout() {
        if (this.currentSection != null && this.currentOptionsArea != null) {
            return new AreaLayout(AreaLayout.LEFT_RIGHT, this.sectionsArea, this.currentOptionsArea);
        }
        return new AreaLayout(this.sectionsArea);
    }

    @Override
    public String getAppName() {
        return this.strings.appName();
    }

    @Override
    public MonoApp.Result onMonoAppSecondInstance(Application app) {
        NullCheck.notNull((Object)app, (String)"app");
        return MonoApp.Result.BRING_FOREGROUND;
    }

    @Override
    public void closeApp() {
        if (this.currentOptionsArea != null && !this.currentOptionsArea.saveSectionData()) {
            return;
        }
        this.luwrain.closeApp();
    }

    @Override
    public void onAppClose() {
    }
}

