/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.console;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.luwrain.app.base.LayoutBase;
import org.luwrain.app.console.App;
import org.luwrain.app.console.ConsoleCommand;
import org.luwrain.app.console.Entry;
import org.luwrain.app.console.Utils;
import org.luwrain.controls.ConsoleArea;
import org.luwrain.controls.ConsoleUtils;
import org.luwrain.core.AreaQuery;
import org.luwrain.core.DefaultEventResponse;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;
import org.luwrain.core.Sounds;
import org.luwrain.core.events.InputEvent;
import org.luwrain.core.events.SystemEvent;

final class MainLayout
extends LayoutBase
implements ConsoleArea.InputHandler {
    private static final Logger LOG = LogManager.getLogger();
    private final App app;
    private final ConsoleArea<Entry> consoleArea;

    MainLayout(final App app) {
        super(app);
        this.app = app;
        this.consoleArea = new ConsoleArea<Entry>(this.consoleParams(params -> {
            params.name = "LUWRAIN";
            params.model = new ConsoleUtils.ListModel<Entry>(app.entries);
            params.appearance = new Appearance();
            params.inputHandler = this;
            params.inputPos = ConsoleArea.InputPos.BOTTOM;
            params.inputPrefix = "LUWRAIN>";
        })){

            @Override
            public boolean onInputEvent(InputEvent event) {
                NullCheck.notNull((Object)event, (String)"event");
                if (app.onInputEvent(this, event)) {
                    return true;
                }
                return super.onInputEvent(event);
            }

            @Override
            public boolean onSystemEvent(SystemEvent event) {
                NullCheck.notNull((Object)event, (String)"event");
                if (app.onSystemEvent(this, event)) {
                    return true;
                }
                return super.onSystemEvent(event);
            }

            @Override
            public boolean onAreaQuery(AreaQuery query) {
                NullCheck.notNull((Object)query, (String)"query");
                if (app.onAreaQuery(this, query)) {
                    return true;
                }
                return super.onAreaQuery(query);
            }
        };
        this.setAreaLayout(this.consoleArea, null);
    }

    @Override
    public ConsoleArea.InputHandler.Result onConsoleInput(ConsoleArea area, String text) {
        if (text.trim().isEmpty()) {
            return ConsoleArea.InputHandler.Result.REJECTED;
        }
        for (ConsoleCommand c : this.app.getCommands()) {
            if (!c.onCommand(text, this.app)) continue;
            this.consoleArea.refresh();
            this.app.getLuwrain().playSound(Sounds.OK);
            return ConsoleArea.InputHandler.Result.CLEAR_INPUT;
        }
        LOG.trace("Unknown command: " + Utils.firstWord(text));
        this.consoleArea.refresh();
        this.app.getLuwrain().playSound(Sounds.ERROR);
        return ConsoleArea.InputHandler.Result.CLEAR_INPUT;
    }

    private final class Appearance
    implements ConsoleArea.Appearance<Entry> {
        private Appearance() {
        }

        @Override
        public void announceItem(Entry entry) {
            if (entry.ex != null) {
                MainLayout.this.app.setEventResponse(DefaultEventResponse.text(Sounds.ATTENTION, MainLayout.this.app.getLuwrain().getSpeakableText(entry.message + ": " + entry.ex.getMessage() + " (" + entry.ex.getClass().getSimpleName() + ")", Luwrain.SpeakableTextType.PROGRAMMING)));
            } else {
                MainLayout.this.app.setEventResponse(DefaultEventResponse.text(Sounds.LIST_ITEM, MainLayout.this.app.getLuwrain().getSpeakableText(entry.message, Luwrain.SpeakableTextType.PROGRAMMING)));
            }
        }

        @Override
        public String getTextAppearance(Entry entry) {
            if (entry.ex != null) {
                return entry.message + ": " + entry.ex.getMessage() + " (" + entry.ex.getClass().getSimpleName() + ")";
            }
            return entry.message;
        }
    }
}

