/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.settings.yandex;

import java.util.Objects;
import org.luwrain.controls.ControlContext;
import org.luwrain.controls.DefaultControlContext;
import org.luwrain.controls.FormArea;
import org.luwrain.core.Luwrain;
import org.luwrain.core.events.InputEvent;
import org.luwrain.core.events.SystemEvent;
import org.luwrain.cpanel.ControlPanel;
import org.luwrain.cpanel.SectionArea;
import org.luwrain.settings.yandex.Config;
import org.luwrain.settings.yandex.Strings;

final class ParamsArea
extends FormArea
implements SectionArea {
    private static final String FOUN_MODELS_API_KEY = "foun-models-api-key";
    private static final String FOUN_MODELS_FOLDER_ID = "foun-models-folder-id";
    private static final String SPEECH_KIT_API_KEY = "speech-kit-api-key";
    private static final String SPEECH_KIT_FOLDER_ID = "speech-kit-folder-id";
    private static final String TRANSLATOR_API_KEY = "translator-api-key";
    private static final String TRANSLATOR_FOLDER_ID = "translator-folder-id";
    private final ControlPanel controlPanel;

    ParamsArea(ControlPanel controlPanel) {
        super((ControlContext)new DefaultControlContext(controlPanel.getCoreInterface()), controlPanel.getCoreInterface().i18n().getStaticStr("CpUiGeneral"));
        this.controlPanel = controlPanel;
        this.fillForm();
    }

    private void fillForm() {
        Luwrain l = this.controlPanel.getCoreInterface();
        Strings s = (Strings)l.i18n().getStrings(Strings.class);
        Config c = Objects.requireNonNullElse((Config)l.loadConf(Config.class), new Config());
        this.addEdit(FOUN_MODELS_API_KEY, s.founModelsApiKey(), Objects.requireNonNullElse(c.getFoundationModelsApiKey(), ""));
        this.addEdit(FOUN_MODELS_FOLDER_ID, s.founModelsFolderId(), Objects.requireNonNullElse(c.getFoundationModelsFolderId(), ""));
        this.addEdit(SPEECH_KIT_API_KEY, s.speechKitApiKey(), Objects.requireNonNullElse(c.getSpeechKitApiKey(), ""));
        this.addEdit(SPEECH_KIT_FOLDER_ID, s.speechKitFolderId(), Objects.requireNonNullElse(c.getSpeechKitFolderId(), ""));
        this.addEdit(TRANSLATOR_API_KEY, s.translatorApiKey(), Objects.requireNonNullElse(c.getTranslatorApiKey(), ""));
        this.addEdit(TRANSLATOR_FOLDER_ID, s.translatorFolderId(), Objects.requireNonNullElse(c.getTranslatorFolderId(), ""));
    }

    public boolean saveSectionData() {
        Luwrain l = this.controlPanel.getCoreInterface();
        l.updateConf(Config.class, c -> {
            c.setFoundationModelsApiKey(this.getEnteredText(FOUN_MODELS_API_KEY));
            c.setFoundationModelsFolderId(this.getEnteredText(FOUN_MODELS_FOLDER_ID));
            c.setSpeechKitApiKey(this.getEnteredText(SPEECH_KIT_API_KEY));
            c.setSpeechKitFolderId(this.getEnteredText(SPEECH_KIT_FOLDER_ID));
            c.setTranslatorApiKey(this.getEnteredText(TRANSLATOR_API_KEY));
            c.setTranslatorFolderId(this.getEnteredText(TRANSLATOR_FOLDER_ID));
        });
        return true;
    }

    public boolean onInputEvent(InputEvent event) {
        if (this.controlPanel.onInputEvent(event)) {
            return true;
        }
        return super.onInputEvent(event);
    }

    public boolean onSystemEvent(SystemEvent event) {
        if (this.controlPanel.onSystemEvent(event)) {
            return true;
        }
        return super.onSystemEvent(event);
    }
}

