/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.popups;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Set;
import org.luwrain.controls.ControlContext;
import org.luwrain.controls.DefaultControlContext;
import org.luwrain.controls.ListArea;
import org.luwrain.controls.ListUtils;
import org.luwrain.core.Luwrain;
import org.luwrain.core.Popup;
import org.luwrain.io.websearch.Entry;
import org.luwrain.io.websearch.Response;
import org.luwrain.popups.ListPopupBase;
import org.luwrain.popups.Popups;

public class WebSearchPopup
extends ListPopupBase<Object>
implements ListArea.ClickHandler<Object> {
    protected final Response resp;
    protected Entry result = null;

    public WebSearchPopup(Luwrain luwrain, String name, Response resp, Set<Popup.Flags> popupFlags) {
        super(luwrain, WebSearchPopup.createParams(luwrain, name, resp), popupFlags);
        this.resp = resp;
        this.setListClickHandler(this);
    }

    public Entry result() {
        return this.result;
    }

    public boolean onListClick(ListArea area, int index, Object item) {
        if (item == null || !(item instanceof Entry)) {
            return false;
        }
        this.result = (Entry)item;
        return this.closing.doOk();
    }

    protected static ListArea.Params<Object> createParams(Luwrain luwrain, String name, Response resp) {
        ListArea.Params params = new ListArea.Params();
        params.context = new DefaultControlContext(luwrain);
        params.flags = EnumSet.of(ListArea.Flags.EMPTY_LINE_TOP);
        params.name = name;
        params.model = new ListUtils.FixedModel(WebSearchPopup.createListItems(resp));
        params.appearance = new Appearance(params.context);
        params.transition = new Transition((ListArea.Model<Object>)params.model);
        return params;
    }

    protected static Object[] createListItems(Response resp) {
        ArrayList<Object> r = new ArrayList<Object>();
        for (Entry i : resp.getEntries()) {
            r.add(i);
            r.add(i.getDisplayUrl());
            r.add(i.getSnippet());
        }
        return r.toArray(new Object[r.size()]);
    }

    public static Entry open(Luwrain luwrain, Response resp) {
        WebSearchPopup popup = new WebSearchPopup(luwrain, resp.getQuery().getText(), resp, Popups.DEFAULT_POPUP_FLAGS);
        luwrain.popup((Popup)popup);
        if (popup.wasCancelled()) {
            return null;
        }
        Entry result = popup.result();
        return result;
    }

    protected static class Appearance
    extends ListUtils.DoubleLevelAppearance<Object> {
        public Appearance(ControlContext context) {
            super(context);
        }

        public boolean isSectionItem(Object obj) {
            return obj instanceof Entry;
        }
    }

    protected static class Transition
    extends ListUtils.DoubleLevelTransition<Object> {
        public Transition(ListArea.Model<Object> model) {
            super(model);
        }

        public boolean isSectionItem(Object obj) {
            return obj instanceof Entry;
        }
    }
}

