/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.io.vfs;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Objects;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.provider.local.LocalFile;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.luwrain.controls.CommanderArea;

public class CommanderModel
implements CommanderArea.Model<FileObject> {
    private static final Logger log = LogManager.getLogger();
    protected final FileSystemManager manager;

    public CommanderModel(FileSystemManager manager) {
        this.manager = Objects.requireNonNull(manager, "manager can't be null");
    }

    public FileObject[] getEntryChildren(FileObject entry) {
        Objects.requireNonNull(entry, "entry can't be null");
        log.trace("Reading children of " + String.valueOf(entry));
        try {
            entry.refresh();
            FileObject[] children = entry.getChildren();
            FileObject parent = entry.getParent();
            if (parent == null) {
                return children;
            }
            ArrayList<FileObject> res = new ArrayList<FileObject>();
            res.add(parent);
            for (FileObject f : children) {
                res.add(f);
            }
            log.trace("Read " + res.size() + " entries in " + String.valueOf(entry));
            return res.toArray(new FileObject[res.size()]);
        }
        catch (Throwable e) {
            log.error("Unable to get children of " + String.valueOf(entry), e);
            return null;
        }
    }

    public FileSystemManager getFileSystemManager() {
        return this.manager;
    }

    public CommanderArea.EntryType getEntryType(FileObject currentLocation, FileObject entry) {
        Objects.requireNonNull(entry, "entry can't be null");
        try {
            if (currentLocation.getParent() != null && currentLocation.getParent().equals(entry)) {
                return CommanderArea.EntryType.PARENT;
            }
            if (entry instanceof LocalFile) {
                Path path = Paths.get(entry.getName().getPath(), new String[0]);
                if (Files.isSymbolicLink(path)) {
                    return Files.isDirectory(path, new LinkOption[0]) ? CommanderArea.EntryType.SYMLINK_DIR : CommanderArea.EntryType.SYMLINK;
                }
                if (Files.isDirectory(path, LinkOption.NOFOLLOW_LINKS)) {
                    return CommanderArea.EntryType.DIR;
                }
                if (Files.isRegularFile(path, LinkOption.NOFOLLOW_LINKS)) {
                    return CommanderArea.EntryType.REGULAR;
                }
                return CommanderArea.EntryType.SPECIAL;
            }
            return entry.getType().hasChildren() ? CommanderArea.EntryType.DIR : CommanderArea.EntryType.REGULAR;
        }
        catch (FileSystemException e) {
            log.error("Unable to get the type of " + String.valueOf(entry), (Throwable)e);
            return CommanderArea.EntryType.REGULAR;
        }
    }

    public FileObject getEntryParent(FileObject entry) {
        Objects.requireNonNull(entry, "entry can't be null");
        try {
            return entry.getParent();
        }
        catch (FileSystemException e) {
            log.error("Unable to get the parent of " + String.valueOf(entry), (Throwable)e);
            return null;
        }
    }
}

