/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.io.filters.html;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Comment;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.luwrain.core.Log;
import org.luwrain.core.NullCheck;
import org.luwrain.io.filters.html.AttrsBase;
import org.luwrain.io.textdoc.ContainerItem;
import org.luwrain.io.textdoc.Heading;
import org.luwrain.io.textdoc.Paragraph;
import org.luwrain.io.textdoc.Root;
import org.luwrain.io.textdoc.Run;
import org.luwrain.io.textdoc.TextRun;

final class Builder
extends AttrsBase {
    private static final String DEFAULT_CHARSET = "UTF-8";
    private Document jsoupDoc = null;
    private URL docUrl = null;
    private final LinkedList<String> hrefStack = new LinkedList();
    private final List<String> allHrefs = new ArrayList<String>();

    Builder() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.luwrain.io.textdoc.Document buildDoc(File file, Properties props) throws IOException {
        NullCheck.notNull((Object)file, (String)"file");
        NullCheck.notNull((Object)props, (String)"props");
        try (FileInputStream is = new FileInputStream(file);){
            org.luwrain.io.textdoc.Document document = this.buildDoc(is, props);
            return document;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.luwrain.io.textdoc.Document buildDoc(String text, Properties props) {
        org.luwrain.io.textdoc.Document document;
        NullCheck.notNull((Object)text, (String)"text");
        NullCheck.notNull((Object)props, (String)"props");
        ByteArrayInputStream is = new ByteArrayInputStream(text.getBytes());
        try {
            document = this.buildDoc(is, props);
        }
        catch (Throwable throwable) {
            try {
                ((InputStream)is).close();
                throw throwable;
            }
            catch (IOException e) {
                Log.error((String)"reader", (String)("unable to read HTML from a string:" + e.getClass().getName() + ":" + e.getMessage()));
                return null;
            }
        }
        ((InputStream)is).close();
        return document;
    }

    public org.luwrain.io.textdoc.Document buildDoc(InputStream is, Properties props) throws IOException {
        NullCheck.notNull((Object)is, (String)"is");
        NullCheck.notNull((Object)props, (String)"props");
        String urlStr = props.getProperty("url");
        if (urlStr == null || urlStr.isEmpty()) {
            throw new IOException("no 'url' property");
        }
        this.docUrl = new URL(urlStr);
        String charsetValue = props.getProperty("charset");
        String charset = charsetValue != null && !charsetValue.isEmpty() ? charsetValue : DEFAULT_CHARSET;
        this.jsoupDoc = Jsoup.parse((InputStream)is, (String)charset, (String)this.docUrl.toString());
        org.luwrain.io.textdoc.Document doc = this.constructDoc();
        doc.setProperty("url", this.docUrl.toString());
        doc.setProperty("contenttype", "FIXMEContentTypes.TEXT_HTML_DEFAULT");
        doc.setProperty("charset", charset);
        return doc;
    }

    private org.luwrain.io.textdoc.Document constructDoc() {
        Root root = new Root();
        HashMap<String, String> meta = new HashMap<String, String>();
        Builder.collectMeta(this.jsoupDoc.head(), meta);
        root.getItems().addAll(this.onNode((Node)this.jsoupDoc.body(), false));
        org.luwrain.io.textdoc.Document doc = new org.luwrain.io.textdoc.Document(root, this.jsoupDoc.title());
        doc.setHrefs(this.allHrefs.toArray(new String[this.allHrefs.size()]));
        return doc;
    }

    private List<ContainerItem> onNode(Node node, boolean preMode) {
        NullCheck.notNull((Object)node, (String)"node");
        ArrayList<ContainerItem> resItems = new ArrayList<ContainerItem>();
        ArrayList<Run> runs = new ArrayList<Run>();
        List nodes = node.childNodes();
        if (nodes == null) {
            return Arrays.asList(new ContainerItem[0]);
        }
        for (Node n : nodes) {
            if (n instanceof TextNode) {
                TextNode textNode = (TextNode)n;
                this.onTextNode(textNode, resItems, runs, preMode);
                continue;
            }
            if (n instanceof Element) {
                Element el = (Element)n;
                this.onElement((Element)n, resItems, runs, preMode);
                continue;
            }
            if (n instanceof Comment) continue;
            Log.warning((String)"reader", (String)("unprocessed node of class " + n.getClass().getName()));
        }
        this.commitParagraph(resItems, runs);
        return resItems;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onElementInPara(Element el, List<ContainerItem> nodes, List<Run> runs, boolean preMode) {
        NullCheck.notNull((Object)el, (String)"el");
        NullCheck.notNull(nodes, (String)"nodes");
        NullCheck.notNull(runs, (String)"runs");
        String name = el.nodeName();
        if (name == null || name.isEmpty()) {
            return;
        }
        String tagName = name.trim().toLowerCase();
        if (tagName.equals("img")) {
            this.onImg(el, runs);
            return;
        }
        String href = tagName.equals("a") ? this.extractHref(el) : null;
        if (href != null) {
            this.hrefStack.add(href);
        }
        try {
            List nn = el.childNodes();
            if (nn == null) {
                return;
            }
            for (Node n : nn) {
                if (n instanceof TextNode) {
                    this.onTextNode((TextNode)n, nodes, runs, preMode);
                    continue;
                }
                if (n instanceof Element) {
                    this.onElement((Element)n, nodes, runs, preMode);
                    continue;
                }
                if (n instanceof Comment) continue;
                Log.warning((String)"reader", (String)("encountering unexpected node of class " + n.getClass().getName()));
            }
        }
        finally {
            if (href != null) {
                this.hrefStack.pollLast();
            }
        }
    }

    private void onElement(Element el, List<ContainerItem> nodes, List<Run> runs, boolean preMode) {
        NullCheck.notNull((Object)el, (String)"el");
        NullCheck.notNull(nodes, (String)"nodes");
        NullCheck.notNull(runs, (String)"runs");
        String name = el.nodeName();
        if (name == null || name.trim().isEmpty()) {
            return;
        }
        String tagName = name.trim().toLowerCase();
        if (tagName.startsWith("g:") || tagName.startsWith("g-") || tagName.startsWith("fb:")) {
            return;
        }
        switch (tagName) {
            case "script": 
            case "style": 
            case "hr": 
            case "input": 
            case "button": 
            case "nobr": 
            case "wbr": 
            case "map": 
            case "svg": {
                return;
            }
            case "pre": {
                this.onPre(el, nodes, runs);
                break;
            }
            case "br": {
                this.commitParagraph(nodes, runs);
                break;
            }
            case "p": 
            case "div": 
            case "main": 
            case "noscript": 
            case "header": 
            case "footer": 
            case "center": 
            case "blockquote": 
            case "tbody": 
            case "figure": 
            case "figcaption": 
            case "caption": 
            case "address": 
            case "nav": 
            case "article": 
            case "noindex": 
            case "iframe": 
            case "form": 
            case "section": 
            case "dl": 
            case "dt": 
            case "dd": 
            case "time": 
            case "aside": {
                this.commitParagraph(nodes, runs);
                this.addAttrs(el);
                List<ContainerItem> nn = this.onNode((Node)el, preMode);
                this.releaseAttrs();
                nodes.addAll(nn);
                break;
            }
            case "h1": 
            case "h2": 
            case "h3": 
            case "h4": 
            case "h5": 
            case "h66": 
            case "h7": 
            case "h8": 
            case "h9": {
                this.commitParagraph(nodes, runs);
                this.addAttrs(el);
                Heading h = new Heading(tagName.trim().charAt(1) - 48);
                h.getItems().addAll(this.onNode((Node)el, preMode));
                h.setAttributes(this.getAttributes());
                this.releaseAttrs();
                nodes.add(h);
                break;
            }
            case "ul": 
            case "ol": 
            case "li": 
            case "table": 
            case "th": 
            case "tr": 
            case "td": {
                this.commitParagraph(nodes, runs);
                this.addAttrs(el);
                Heading h = new Heading(1);
                h.getItems().addAll(this.onNode((Node)el, preMode));
                h.setAttributes(this.getAttributes());
                this.releaseAttrs();
                nodes.add(h);
                break;
            }
            case "img": 
            case "a": 
            case "tt": 
            case "code": 
            case "b": 
            case "s": 
            case "ins": 
            case "em": 
            case "i": 
            case "u": 
            case "big": 
            case "small": 
            case "strong": 
            case "span": 
            case "cite": 
            case "font": 
            case "sup": 
            case "label": {
                this.addAttrs(el);
                this.onElementInPara(el, nodes, runs, preMode);
                this.releaseAttrs();
                break;
            }
            default: {
                Log.warning((String)"reader", (String)("unprocessed tag:" + tagName));
            }
        }
    }

    private void onTextNode(TextNode textNode, List<ContainerItem> nodes, List<Run> runs, boolean preMode) {
        NullCheck.notNull((Object)textNode, (String)"textNode");
        NullCheck.notNull(nodes, (String)"nodes");
        NullCheck.notNull(runs, (String)"runs");
        String text = textNode.text();
        if (text == null || text.isEmpty()) {
            return;
        }
        if (!preMode) {
            runs.add(new TextRun(text, !this.hrefStack.isEmpty() ? this.hrefStack.getLast() : "", this.getAttributes()));
            return;
        }
        String[] lines = text.split("\n", -1);
        if (lines.length == 0) {
            return;
        }
        runs.add(new TextRun(lines[0], !this.hrefStack.isEmpty() ? this.hrefStack.getLast() : "", this.getAttributes()));
        for (int i = 1; i < lines.length; ++i) {
            this.commitParagraph(nodes, runs);
            runs.add(new TextRun(lines[i], !this.hrefStack.isEmpty() ? this.hrefStack.getLast() : "", this.getAttributes()));
        }
    }

    private void commitParagraph(List<ContainerItem> nodes, List<Run> runs) {
        NullCheck.notNull(nodes, (String)"nodes");
        NullCheck.notNull(runs, (String)"runs");
        if (runs.isEmpty()) {
            return;
        }
        Paragraph p = new Paragraph(runs);
        p.setAttributes(this.getAttributes());
        nodes.add(p);
        runs.clear();
    }

    private void onImg(Element el, List<Run> runs) {
        NullCheck.notNull((Object)el, (String)"el");
        NullCheck.notNull(runs, (String)"runs");
        String value = el.attr("alt");
        if (value != null && !value.isEmpty()) {
            runs.add(new TextRun("[" + value + "]", !this.hrefStack.isEmpty() ? this.hrefStack.getLast() : "", this.getAttributes()));
        }
    }

    private String extractHref(Element el) {
        String value = el.attr("href");
        if (value == null) {
            return null;
        }
        this.allHrefs.add(value);
        try {
            return new URL(this.docUrl, value).toString();
        }
        catch (MalformedURLException e) {
            return value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onPre(Element el, List<ContainerItem> items, List<Run> runs) {
        NullCheck.notNull((Object)el, (String)"el");
        NullCheck.notNull(items, (String)"items");
        NullCheck.notNull(runs, (String)"runs");
        this.commitParagraph(items, runs);
        this.addAttrs(el);
        try {
            for (ContainerItem n : this.onNode((Node)el, true)) {
                items.add(n);
            }
            this.commitParagraph(items, runs);
        }
        finally {
            this.releaseAttrs();
        }
    }
}

