/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.io.download;

import java.util.ArrayList;
import org.luwrain.core.NullCheck;
import org.luwrain.core.Registry;
import org.luwrain.core.RegistryProxy;

public interface Settings {
    public static final String COMPLETED = "completed";
    public static final String FAILED = "failed";
    public static final String DOWNLOAD_PATH = "/org/luwrain/io/download";

    public static Entry createEntry(Registry registry, int id) {
        NullCheck.notNull((Object)registry, (String)"registry");
        if (id < 0) {
            throw new IllegalArgumentException("id may not be negative (" + id + ")");
        }
        String path = Registry.join((String)DOWNLOAD_PATH, (String)("" + id));
        registry.addDirectory(path);
        return (Entry)RegistryProxy.create((Registry)registry, (String)path, Entry.class);
    }

    public static int addEntry(Registry registry, String url, String destFile) {
        NullCheck.notNull((Object)registry, (String)"registry");
        NullCheck.notEmpty((Object)url, (String)"url");
        NullCheck.notEmpty((Object)destFile, (String)"destFile");
        registry.addDirectory(DOWNLOAD_PATH);
        int id = Registry.nextFreeNum((Registry)registry, (String)DOWNLOAD_PATH);
        Entry entry = Settings.createEntry(registry, id);
        entry.setUrl(url);
        entry.setDestFile(destFile);
        return id;
    }

    public static int[] getIds(Registry registry) {
        NullCheck.notNull((Object)registry, (String)"registry");
        registry.addDirectory(DOWNLOAD_PATH);
        String[] dirs = registry.getDirectories(DOWNLOAD_PATH);
        ArrayList<Integer> res = new ArrayList<Integer>();
        for (String s : dirs) {
            try {
                res.add(new Integer(Integer.parseInt(s)));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        int[] ints = new int[res.size()];
        for (int i = 0; i < ints.length; ++i) {
            ints[i] = (Integer)res.get(i);
        }
        return ints;
    }

    public static interface Entry {
        public String getUrl(String var1);

        public void setUrl(String var1);

        public String getDestFile(String var1);

        public void setDestFile(String var1);

        public String getStatus(String var1);

        public void setStatus(String var1);

        public String getErrorInfo(String var1);

        public void setErrorInfo(String var1);
    }
}

