/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.io.api.mediawiki;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import org.jsoup.Connection;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.luwrain.core.NullCheck;
import org.luwrain.io.api.mediawiki.Page;

public final class Mediawiki {
    private final String baseUrl;

    public Mediawiki(String baseUrl) {
        NullCheck.notEmpty((Object)baseUrl, (String)"baseUrl");
        this.baseUrl = baseUrl.endsWith("/") ? baseUrl : baseUrl + "/";
    }

    public Page[] search(String q) throws IOException {
        String url = this.baseUrl + "api.php?action=query&list=search&srsearch=" + URLEncoder.encode(q, "UTF-8") + "&format=xml";
        Connection con = Jsoup.connect((String)url);
        Document doc = con.get();
        Elements pages = doc.getElementsByTag("p");
        ArrayList<Page> res = new ArrayList<Page>();
        for (Element page : pages) {
            String title = page.attr("title");
            String comment = page.attr("snippet");
            if (title == null || title.isEmpty()) continue;
            if (comment == null) {
                comment = "";
            }
            comment = Mediawiki.stripTags(comment);
            res.add(new Page(this.baseUrl, title, comment));
        }
        return res.toArray(new Page[res.size()]);
    }

    private static String stripTags(String s) {
        return s.replaceAll("</span>", "").replaceAll("<span class=.searchmatch.>", "");
    }
}

