/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.controls;

import org.luwrain.controls.ControlContext;
import org.luwrain.controls.EditSpellChecking;
import org.luwrain.controls.NavigationArea;
import org.luwrain.controls.edit.EditArea;
import org.luwrain.core.DefaultEventResponse;
import org.luwrain.core.LineMarks;
import org.luwrain.core.Luwrain;
import org.luwrain.core.MutableMarkedLines;
import org.luwrain.core.NullCheck;
import org.luwrain.core.Sounds;
import org.luwrain.core.events.SystemEvent;
import org.luwrain.nlp.SpellProblem;

public class SpellCheckingEditArea
extends EditArea {
    protected final EditSpellChecking spellChecking;

    public SpellCheckingEditArea(Luwrain luwrain, EditArea.Params params) {
        super(params);
        this.spellChecking = new EditSpellChecking(luwrain);
        this.changeListeners.add(this.spellChecking);
    }

    public boolean onSystemEvent(SystemEvent event) {
        NullCheck.notNull((Object)event, (String)"event");
        if (event.getType() != SystemEvent.Type.REGULAR) {
            return super.onSystemEvent(event);
        }
        switch (event.getCode()) {
            case IDLE: {
                return this.onIdle(event);
            }
        }
        return super.onSystemEvent(event);
    }

    protected boolean onIdle(SystemEvent event) {
        MutableMarkedLines lines = this.getContent();
        int x = this.getHotPointX();
        int y = this.getHotPointY();
        if (y >= lines.getLineCount()) {
            return true;
        }
        LineMarks marks = lines.getLineMarks(y);
        if (marks == null) {
            return true;
        }
        LineMarks.Mark[] atPoint = marks.findAtPos(x);
        if (atPoint == null || atPoint.length == 0) {
            return true;
        }
        for (LineMarks.Mark m : atPoint) {
            if (m.getMarkObject() == null || !(m.getMarkObject() instanceof SpellProblem)) continue;
            SpellProblem p = (SpellProblem)m.getMarkObject();
            this.context.message(p.getComment(), Luwrain.MessageType.ANNOUNCEMENT);
            return true;
        }
        return true;
    }

    public void announceLine(int index, String line) {
        String text = this.getSpeakableText(line);
        if (!this.hasSpellProblems(index)) {
            NavigationArea.defaultLineAnnouncement((ControlContext)this.context, (int)index, (String)text);
        } else {
            this.context.setEventResponse(DefaultEventResponse.text((Sounds)Sounds.SPELLING, (String)text));
        }
    }

    public String getSpeakableText(String text) {
        return this.context.getSpeakableText(text, Luwrain.SpeakableTextType.NATURAL);
    }

    public boolean hasSpellProblems(int lineIndex) {
        if (this.getContent().getLineMarks(lineIndex) == null) {
            return false;
        }
        LineMarks.Mark[] marks = this.getContent().getLineMarks(lineIndex).getMarks();
        if (marks == null) {
            return false;
        }
        for (LineMarks.Mark m : marks) {
            if (m.getMarkObject() == null || !(m.getMarkObject() instanceof SpellProblem)) continue;
            return true;
        }
        return false;
    }
}

