/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.controls;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.luwrain.controls.DefaultLineMarks;
import org.luwrain.controls.edit.EditArea;
import org.luwrain.controls.edit.EditUtils;
import org.luwrain.core.HotPoint;
import org.luwrain.core.LineMarks;
import org.luwrain.core.Log;
import org.luwrain.core.Luwrain;
import org.luwrain.core.MarkedLines;
import org.luwrain.core.MutableMarkedLines;
import org.luwrain.core.NullCheck;
import org.luwrain.nlp.SpellChecker;
import org.luwrain.nlp.SpellCheckerFactory;
import org.luwrain.nlp.SpellProblem;
import org.luwrain.nlp.SpellText;

public class EditSpellChecking
implements EditArea.ChangeListener {
    private static final String LOG_COMPONENT = "spelling";
    private final Luwrain luwrain;
    private final SpellChecker checker;

    public EditSpellChecking(Luwrain luwrain, String lang) {
        NullCheck.notNull((Object)luwrain, (String)"luwrain ");
        NullCheck.notEmpty((Object)lang, (String)"lang");
        this.luwrain = luwrain;
        this.checker = new SpellCheckerFactory().newChecker(luwrain, lang);
    }

    public EditSpellChecking(Luwrain luwrain) {
        this(luwrain, "ru");
    }

    public void onEditChange(EditArea editArea, MarkedLines lines, HotPoint hotPoint) {
        TreeMap text = new TreeMap();
        EditUtils.blockBounds((EditArea)editArea, (int)hotPoint.getHotPointY(), (line, marks) -> !line.trim().isEmpty(), (lines_, index) -> text.put(index, lines.getLine(index.intValue())));
        this.luwrain.executeBkg(() -> this.check(editArea, text));
    }

    public void initialChecking(EditArea editArea) {
        TreeMap<Integer, String> text = new TreeMap<Integer, String>();
        MutableMarkedLines lines = editArea.getContent();
        for (int i = 0; i < lines.getLineCount(); ++i) {
            text.put(i, lines.getLine(i));
        }
        this.luwrain.executeBkg(() -> this.check(editArea, text));
    }

    public void eraseSpellingMarks(EditArea editArea) {
        editArea.update((lines, hotPoint) -> {
            for (int i = 0; i < lines.getLineCount(); ++i) {
                LineMarks marks = lines.getLineMarks(i);
                if (marks == null) continue;
                lines.setLineMarks(i, marks.filter(mark -> mark.getMarkObject() == null || !(mark.getMarkObject() instanceof SpellProblem)));
            }
            return false;
        });
    }

    private void check(EditArea editArea, SortedMap<Integer, String> text) {
        ArrayList<String> textLines = new ArrayList<String>();
        for (Map.Entry<Integer, String> e : text.entrySet()) {
            textLines.add(e.getValue());
        }
        SpellText spellText = new SpellText(textLines.toArray(new String[textLines.size()]), this.checker);
        List<List<LineMarks.Mark>> marks = spellText.buildMarks();
        this.luwrain.runUiSafely(() -> this.setResult(editArea, text, marks));
    }

    private void setResult(EditArea editArea, SortedMap<Integer, String> text, List<List<LineMarks.Mark>> marks) {
        editArea.update((lines, hotPoint) -> {
            int index = 0;
            for (Map.Entry e : text.entrySet()) {
                int lineIndex = (Integer)e.getKey();
                lines.setLineMarks(lineIndex, (LineMarks)new DefaultLineMarks.Builder(lines.getLineMarks(lineIndex)).addAll((List)marks.get(index)).build());
                Log.debug((String)LOG_COMPONENT, (String)("Result for line " + lineIndex + ", " + String.valueOf(((List)marks.get(index)).size()) + " marks"));
                for (LineMarks.Mark m : (List)marks.get(index)) {
                    Log.debug((String)LOG_COMPONENT, (String)m.getMarkObject().toString());
                }
                ++index;
            }
            return false;
        });
    }

    public SpellChecker getSpellChecker() {
        return this.checker;
    }
}

