/*
 * Decompiled with CFR 0.152.
 */
package com.github.olga_yakovleva.rhvoice;

import com.github.olga_yakovleva.rhvoice.Logger;
import com.github.olga_yakovleva.rhvoice.RHVoiceException;
import com.github.olga_yakovleva.rhvoice.SynthesisParameters;
import com.github.olga_yakovleva.rhvoice.TTSClient;
import com.github.olga_yakovleva.rhvoice.TextUtils;
import com.github.olga_yakovleva.rhvoice.VoiceInfo;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.List;

public final class TTSEngine {
    private long data;
    private static boolean jniLoaded = false;

    private static native void onClassInit();

    private native void onInit(String var1, String var2, String[] var3, Logger var4) throws RHVoiceException;

    private native void onShutdown();

    private native VoiceInfo[] doGetVoices();

    private native void doSpeak(String var1, SynthesisParameters var2, TTSClient var3) throws RHVoiceException;

    private native boolean doConfigure(String var1, String var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void loadJniLib(ClassLoader classLoader, String resName) {
        try {
            URL url = classLoader.getResource(resName);
            if (url == null) {
                throw new RuntimeException("No resource " + resName);
            }
            File tmpFile = File.createTempFile(".rhvoice.jni.", ".tmp");
            try (InputStream is = url.openStream();){
                Files.copy(is, tmpFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            System.load(tmpFile.getAbsolutePath());
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new RuntimeException("Unable to load " + resName, e);
        }
    }

    static void loadJni(ClassLoader classLoader) {
        if (jniLoaded) {
            return;
        }
        String arch = System.getProperty("sun.arch.data.model");
        System.out.println("os.arch = " + System.getProperty("os.arch"));
        String os = System.getProperty("os.arch").equals("arm") ? "arm" : System.getProperty("os.name");
        if (os.toUpperCase().equals("ARM")) {
            String resPrefix = "com/github/olga_yakovleva/rhvoice/jni/arm/" + arch + "/";
            TTSEngine.loadJniLib(classLoader, resPrefix + "libRHVoice_core.so");
            TTSEngine.loadJniLib(classLoader, resPrefix + "libRHVoice_jni.so");
            TTSEngine.loadJniLib(classLoader, resPrefix + "libRHVoice.so");
        } else if (os.toUpperCase().equals("LINUX")) {
            String resPrefix = "com/github/olga_yakovleva/rhvoice/jni/Linux/" + arch + "/";
            TTSEngine.loadJniLib(classLoader, resPrefix + "libRHVoice_core.so");
            TTSEngine.loadJniLib(classLoader, resPrefix + "libRHVoice_jni.so");
            TTSEngine.loadJniLib(classLoader, resPrefix + "libRHVoice.so");
        } else {
            String resPrefix = "com/github/olga_yakovleva/rhvoice/jni/Windows/" + arch + "/";
            TTSEngine.loadJniLib(classLoader, resPrefix + "RHVoice_jni.dll");
        }
        TTSEngine.onClassInit();
        jniLoaded = true;
    }

    public TTSEngine(String data_path, String config_path, String[] resource_paths, Logger logger) throws RHVoiceException {
        if (logger == null) {
            throw new NullPointerException("logger can't be null");
        }
        TTSEngine.loadJni(this.getClass().getClassLoader());
        this.onInit(data_path, config_path, resource_paths, logger);
    }

    public TTSEngine(String data_path, String config_path, List<String> resource_paths, Logger logger) throws RHVoiceException {
        this(data_path, config_path, resource_paths.toArray(new String[resource_paths.size()]), logger);
    }

    public TTSEngine() throws RHVoiceException {
        this("", "", new String[0], null);
    }

    public void shutdown() {
        this.onShutdown();
    }

    public List<VoiceInfo> getVoices() {
        return Arrays.asList(this.doGetVoices());
    }

    public void speak(String text, SynthesisParameters params, TTSClient client) throws RHVoiceException {
        if (params.getVoiceProfile() == null) {
            throw new RHVoiceException("Voice not set");
        }
        this.doSpeak(text, params, client);
    }

    public boolean configure(String key, String value) {
        if (TextUtils.isEmpty(key)) {
            return false;
        }
        if (TextUtils.isEmpty(value)) {
            return false;
        }
        return this.doConfigure(key, value);
    }
}

