/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.player;

import com.mpatric.mp3agic.ID3v1;
import com.mpatric.mp3agic.ID3v2;
import com.mpatric.mp3agic.InvalidDataException;
import com.mpatric.mp3agic.Mp3File;
import com.mpatric.mp3agic.UnsupportedTagException;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.luwrain.util.Urls;

final class TrackInfo {
    private static final String charset = "windows-1251";
    final String track;
    final String artist;
    final String title;
    final String album;
    final String comment;
    final long length;
    final int bitrate;
    final int sampleRate;
    final boolean vbr;

    TrackInfo(URL url) throws IOException {
        Mp3File mp3file;
        try {
            File file = Urls.toFile((URL)url);
            if (file == null) {
                throw new IOException(String.valueOf(url) + " not a local file");
            }
            mp3file = new Mp3File(file);
        }
        catch (InvalidDataException | UnsupportedTagException e) {
            throw new IOException("Unable to read tags of " + url.toString(), e);
        }
        this.length = mp3file.getLengthInSeconds();
        this.bitrate = mp3file.getBitrate();
        this.vbr = mp3file.isVbr();
        this.sampleRate = mp3file.getSampleRate();
        String track = null;
        String artist = null;
        String title = "";
        String album = null;
        String comment = null;
        if (mp3file.hasId3v2Tag()) {
            ID3v2 id3v2Tag = mp3file.getId3v2Tag();
            track = id3v2Tag.getTrack();
            artist = id3v2Tag.getArtist();
            title = id3v2Tag.getTitle();
            album = id3v2Tag.getAlbum();
            comment = id3v2Tag.getComment();
        }
        if (mp3file.hasId3v1Tag()) {
            ID3v1 id3v1Tag = mp3file.getId3v1Tag();
            if (track == null || track.isEmpty()) {
                track = id3v1Tag.getTrack();
            }
            if (artist == null || artist.isEmpty()) {
                artist = id3v1Tag.getArtist();
            }
            if (title == null || title.isEmpty()) {
                title = id3v1Tag.getTitle();
            }
            if (album == null || album.isEmpty()) {
                album = id3v1Tag.getAlbum();
            }
            if (comment == null || comment.isEmpty()) {
                comment = id3v1Tag.getComment();
            }
        }
        if (artist == null) {
            artist = "";
        }
        if (title == null) {
            title = "";
        }
        if (album == null) {
            album = "";
        }
        if (comment == null) {
            comment = "";
        }
        if (track == null) {
            track = "";
        }
        this.track = this.transcode(track);
        this.artist = this.transcode(artist);
        this.title = this.transcode(title);
        this.album = this.transcode(album);
        this.comment = this.transcode(comment);
    }

    private String transcode(String value) throws IOException {
        if (charset == null || charset.isEmpty()) {
            return value;
        }
        byte[] bytes = value.getBytes("ISO-8859-1");
        return new String(bytes, charset);
    }
}

