/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.player;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.luwrain.app.base.TaskCancelling;
import org.luwrain.app.player.Album;
import org.luwrain.app.player.App;
import org.luwrain.player.FixedPlaylist;
import org.luwrain.player.Player;
import org.luwrain.player.Playlist;
import org.luwrain.util.UrlUtils;

final class Starting {
    private static final long SAVE_POS_STEP = 1000L;
    private final App app;

    Starting(App app) {
        this.app = app;
    }

    private boolean onDir(Album album) {
        String path = album.getPath();
        if (path.isEmpty()) {
            return false;
        }
        ArrayList urls = new ArrayList();
        TaskCancelling.TaskId taskId = this.app.newTaskId();
        return this.app.runTask(taskId, () -> {
            this.collectMusicFiles(new File(path), urls);
            this.app.finishedTask(taskId, () -> {
                AtomicLong prevPosMsec = new AtomicLong(album.getPosMsec());
                FixedPlaylist playlist = new FixedPlaylist(urls.toArray(new String[urls.size()]), (trackNum, posMsec) -> {
                    if (!album.isSavePosition()) {
                        return;
                    }
                    if (Math.abs(posMsec - prevPosMsec.get()) < 1000L) {
                        return;
                    }
                    prevPosMsec.set(posMsec);
                    album.setTrackNum(trackNum);
                    album.setPosMsec(posMsec);
                    this.app.getAlbums().save();
                }, value -> {
                    album.setVolume(value);
                    this.app.getAlbums().save();
                }, album.getVolume());
                this.app.getPlayer().play((Playlist)playlist, album.isSavePosition() ? album.getTrackNum() : 0, album.isSavePosition() ? album.getPosMsec() : 0L, EnumSet.noneOf(Player.Flags.class));
            });
        });
    }

    private boolean onStreaming(Album album) {
        String url = album.getUrl();
        if (url == null || url.trim().isEmpty()) {
            return false;
        }
        FixedPlaylist playlist = new FixedPlaylist(new String[]{url.trim()}, value -> {
            album.setVolume(value);
            this.app.getAlbums().save();
        }, album.getVolume());
        this.app.getPlayer().play((Playlist)playlist, 0, 0L, EnumSet.of(Player.Flags.STREAMING));
        return true;
    }

    private void collectMusicFiles(File file, List<String> res) {
        if (!file.exists()) {
            return;
        }
        if (file.isFile()) {
            String name = file.getName().toLowerCase();
            if (name.endsWith(".mp3")) {
                res.add(UrlUtils.fileToUrl((File)file));
            }
            return;
        }
        if (!file.isDirectory()) {
            return;
        }
        Object[] files = file.listFiles();
        if (files != null) {
            Arrays.sort(files);
            for (Object f : files) {
                this.collectMusicFiles((File)f, res);
            }
        }
    }

    boolean play(Album album) {
        if (album.getType() == null) {
            return false;
        }
        switch (album.getType()) {
            case STREAMING: {
                return this.onStreaming(album);
            }
            case DIR: {
                return this.onDir(album);
            }
        }
        return false;
    }
}

