/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.player;

import com.google.auto.service.AutoService;
import java.io.File;
import java.net.URL;
import org.luwrain.app.player.App;
import org.luwrain.core.Application;
import org.luwrain.core.Command;
import org.luwrain.core.DefaultShortcut;
import org.luwrain.core.EmptyExtension;
import org.luwrain.core.ExtensionObject;
import org.luwrain.core.Luwrain;
import org.luwrain.core.Shortcut;
import org.luwrain.core.SimpleShortcutCommand;
import org.luwrain.core.Sounds;
import org.luwrain.player.FixedPlaylist;
import org.luwrain.player.Player;
import org.luwrain.player.Playlist;
import org.luwrain.util.Urls;

@AutoService(value={org.luwrain.core.Extension.class})
public final class Extension
extends EmptyExtension {
    private static final int VOLUME_STEP = 3;

    public Command[] getCommands(Luwrain luwrain) {
        return new Command[]{new SimpleShortcutCommand("player"), new Command(){

            public String getName() {
                return "player-pause";
            }

            public void onCommand(Luwrain luwrain) {
                Player player = luwrain.getPlayer();
                if (player != null) {
                    player.pauseResume();
                } else {
                    luwrain.playSound(Sounds.BLOCKED);
                }
            }
        }};
    }

    public ExtensionObject[] getExtObjects(final Luwrain luwrain) {
        return new Shortcut[]{new DefaultShortcut("player", App.class){

            public Application[] prepareApp(String[] args) {
                return new Application[]{new App(args)};
            }
        }, new DefaultShortcut("player-single-local", App.class){

            public Application[] prepareApp(String[] args) {
                if (args.length != 1 || args[0].isEmpty()) {
                    return null;
                }
                Player player = luwrain.getPlayer();
                if (player != null) {
                    File f = new File(args[0]).getAbsoluteFile();
                    URL url = Urls.toUrl((File)f);
                    if (url == null) {
                        return null;
                    }
                    player.play((Playlist)new FixedPlaylist(url.toString()), 0, 0L, Player.DEFAULT_FLAGS);
                }
                return new Application[0];
            }
        }};
    }
}

