/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.player;

import java.io.File;
import org.luwrain.app.player.Album;
import org.luwrain.app.player.App;
import org.luwrain.app.player.Strings;
import org.luwrain.core.Luwrain;
import org.luwrain.popups.Popups;

public final class Conv {
    private final Luwrain luwrain;
    private final Strings strings;

    Conv(App app) {
        this.luwrain = app.getLuwrain();
        this.strings = (Strings)app.getStrings();
    }

    Album.Type newAlbumType() {
        String sect = this.strings.albumTypeSection();
        String dir = this.strings.albumTypeDir();
        String m3u = this.strings.albumTypeM3u();
        String streaming = this.strings.albumTypeStreaming();
        Object typeRes = Popups.fixedList((Luwrain)this.luwrain, (String)this.strings.newAlbumTypePopupName(), (Object[])new Object[]{dir, streaming, sect});
        if (typeRes == null) {
            return null;
        }
        if (typeRes == sect) {
            return Album.Type.SECTION;
        }
        if (typeRes == dir) {
            return Album.Type.DIR;
        }
        if (typeRes == m3u) {
            return Album.Type.M3U;
        }
        if (typeRes == streaming) {
            return Album.Type.STREAMING;
        }
        return null;
    }

    boolean confirmAlbumDeleting(Album album) {
        return Popups.confirmDefaultNo((Luwrain)this.luwrain, (String)this.strings.albumDeletingPopupName(), (String)this.strings.albumDeletingPopupText(album.getTitle()));
    }

    String newAlbumTitle() {
        return Popups.textNotEmpty((Luwrain)this.luwrain, (String)this.strings.newAlbumPopupName(), (String)this.strings.newAlbumTitlePopupPrefix(), (String)"");
    }

    String newSectionTitle() {
        return Popups.textNotEmpty((Luwrain)this.luwrain, (String)this.strings.newSectionPopupName(), (String)this.strings.newSectionTitlePopupPrefix(), (String)"");
    }

    String newStreamingAlbumUrl() {
        return Popups.textNotEmpty((Luwrain)this.luwrain, (String)"\u041d\u043e\u0432\u044b\u0439 \u0430\u043b\u044c\u0431\u043e\u043c", (String)"\u0410\u0434\u0440\u0435\u0441 \u043f\u043e\u0442\u043e\u043a\u0430 \u0440\u0430\u0434\u0438\u043e\u0441\u0442\u0430\u043d\u0446\u0438\u0438:", (String)"http://");
    }

    public File dirAlbumPath() {
        return Popups.existingDir((Luwrain)this.luwrain, (String)"\u041a\u0430\u0442\u0430\u043b\u043e\u0433 \u0441 \u0444\u0430\u0439\u043b\u0430\u043c\u0438 \u0430\u043b\u044c\u0431\u043e\u043c\u0430:");
    }
}

