/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.web.chromite;

import com.github.kklisura.cdt.protocol.commands.Page;
import com.github.kklisura.cdt.protocol.commands.Runtime;
import com.github.kklisura.cdt.protocol.types.runtime.Evaluate;
import com.github.kklisura.cdt.services.ChromeDevToolsService;
import com.github.kklisura.cdt.services.ChromeService;
import com.github.kklisura.cdt.services.impl.ChromeServiceImpl;
import com.github.kklisura.cdt.services.types.ChromeTab;
import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.luwrain.web.chromite.Elements;

public class Chromite
implements AutoCloseable {
    final ChromeService chromeService;
    final ChromeTab tab;
    final ChromeDevToolsService devToolsService;
    final Page page;
    final Runtime runtime;
    final Gson gson = new Gson();

    public Chromite() {
        this.chromeService = new ChromeServiceImpl("localhost", 9222);
        this.tab = this.chromeService.createTab();
        this.devToolsService = this.chromeService.createDevToolsService(this.tab);
        this.page = this.devToolsService.getPage();
        this.runtime = this.devToolsService.getRuntime();
    }

    @Override
    public void close() {
        this.devToolsService.close();
        this.chromeService.closeTab(this.tab);
    }

    public void navigate(String url) {
        this.page.navigate(url);
    }

    public String getHtml() {
        Evaluate evaluation = this.runtime.evaluate("document.documentElement.outerHTML");
        return evaluation.getResult().getValue().toString();
    }

    public Elements getPage() {
        String script = Chromite.concatLines(this.readResource("page.js"));
        Evaluate evaluation = this.runtime.evaluate(script);
        return (Elements)this.gson.fromJson(evaluation.getResult().getValue().toString(), Elements.class);
    }

    private void setOnLoadEvent() {
        this.page.onLoadEventFired(event -> {});
    }

    String[] readResource(String resName) {
        try {
            ArrayList<String> res = new ArrayList<String>();
            try (BufferedReader r = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(resName), "UTF-8"));){
                String line = r.readLine();
                while (line != null) {
                    res.add(line);
                    line = r.readLine();
                }
            }
            return res.toArray(new String[res.size()]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static String concatLines(String[] lines) {
        StringBuilder b = new StringBuilder();
        for (String l : lines) {
            b.append(l).append(" ");
        }
        return new String(b);
    }
}

