/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.web;

import com.sun.webkit.dom.DOMWindowImpl;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javafx.scene.web.WebEngine;
import netscape.javascript.JSObject;
import org.luwrain.app.webinspector.App;
import org.luwrain.core.Log;
import org.luwrain.graphical.FxThread;
import org.luwrain.util.ResourceUtils;
import org.luwrain.web.GeomEntry;
import org.w3c.dom.Node;
import org.w3c.dom.html.HTMLDocument;
import org.w3c.dom.views.DocumentView;

public final class WebKitGeom {
    static final String LOG_COMPONENT = "web";
    static final String INJECTION_NAME = "injection.js";
    private static String injection = null;
    final WebEngine engine;
    private Scanner scanner = null;

    public WebKitGeom(WebEngine engine) {
        this.engine = engine;
        try {
            if (injection == null) {
                injection = ResourceUtils.getStringResource(this.getClass(), (String)INJECTION_NAME);
                Log.debug((String)LOG_COMPONENT, (String)"the web injection loaded");
                App.log("The injection loaded");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public GeomEntry getEntry(Node node) {
        FxThread.ensure();
        if (this.scanner != null) {
            return this.scanner.nodes.get(node);
        }
        Object res = this.engine.executeScript(injection);
        if (res == null) {
            throw new RuntimeException("The result of web scanning is null");
        }
        if (!(res instanceof JSObject)) {
            throw new RuntimeException("The result of web scanning is not an instance of JSObject");
        }
        Log.debug((String)LOG_COMPONENT, (String)"Performing scanning of the web page");
        App.log("Performing scanning of the web page");
        JSObject jsRes = (JSObject)res;
        this.scanner = new Scanner(jsRes);
        return this.scanner.nodes.get(node);
    }

    final class Scanner {
        final Map<Node, GeomEntry> nodes = new HashMap<Node, GeomEntry>();

        Scanner(JSObject src) {
            Object o;
            FxThread.ensure();
            HTMLDocument doc = (HTMLDocument)WebKitGeom.this.engine.getDocument();
            DOMWindowImpl window = (DOMWindowImpl)((DocumentView)((Object)doc)).getDefaultView();
            JSObject root = (JSObject)src.getMember("dom");
            int i = 0;
            while (!(o = root.getSlot(i)).getClass().equals(String.class)) {
                JSObject jsObj = (JSObject)o;
                JSObject rect = (JSObject)jsObj.getMember("rect");
                String text = (String)jsObj.getMember("text");
                Node node = (Node)jsObj.getMember("node");
                int x = -1;
                int y = -1;
                int width = -1;
                int height = -1;
                if (rect != null) {
                    x = this.intValue(rect.getMember("left"));
                    y = this.intValue(rect.getMember("top"));
                    width = this.intValue(rect.getMember("width"));
                    height = this.intValue(rect.getMember("height"));
                }
                this.nodes.put(node, new GeomEntry(x, y, width, height, String.valueOf(text)));
                ++i;
            }
            Log.debug((String)WebKitGeom.LOG_COMPONENT, (String)("geom scanning completed: " + this.nodes.size()));
        }

        int intValue(Object o) {
            if (o == null) {
                return 0;
            }
            if (o instanceof Number) {
                return ((Number)o).intValue();
            }
            return Double.valueOf(Double.parseDouble(o.toString())).intValue();
        }
    }
}

