/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.lsocial.layouts;

import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.luwrain.app.base.AppBase;
import org.luwrain.app.base.LayoutBase;
import org.luwrain.app.lsocial.App;
import org.luwrain.app.lsocial.Strings;
import org.luwrain.controls.FormArea;
import org.luwrain.core.Area;

public final class OptionsLayout
extends LayoutBase {
    private static final Logger log = LogManager.getLogger();
    private static final String ACCESS_TOKEN = "access-token";
    private static final String YANDEX_FOLDER_ID = "yandex-folder-id";
    private static final String YANDEX_API_KEY = "yandex-api-key";
    final App app;
    final FormArea form;

    public OptionsLayout(App app, LayoutBase.ActionHandler close) {
        super((AppBase)app);
        this.app = app;
        Strings s = (Strings)app.getStrings();
        this.form = new FormArea(this.getControlContext(), s.optionsAreaName());
        this.form.addEdit(ACCESS_TOKEN, s.accessTokenEdit(), Objects.requireNonNullElse(app.conf.getAccessToken(), ""));
        this.form.addEdit(YANDEX_FOLDER_ID, s.yandexFolderIdEdit(), Objects.requireNonNullElse(app.conf.getYandexFolderId(), ""));
        this.form.addEdit(YANDEX_API_KEY, s.yandexApiKeyEdit(), Objects.requireNonNullElse(app.conf.getYandexApiKey(), ""));
        this.setAreaLayout((Area)this.form, null);
        this.setOkHandler(() -> {
            app.conf.setAccessToken(this.form.getEnteredText(ACCESS_TOKEN));
            app.conf.setYandexFolderId(this.form.getEnteredText(YANDEX_FOLDER_ID));
            app.conf.setYandexApiKey(this.form.getEnteredText(YANDEX_API_KEY));
            app.getLuwrain().saveConf((Object)app.conf);
            close.onAction();
            return true;
        });
        log.debug("Setting close handler");
        this.setCloseHandler(close);
    }
}

