/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.util;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dizitart.no2.Document;
import org.dizitart.no2.NitriteId;
import org.dizitart.no2.exceptions.ErrorMessage;
import org.dizitart.no2.exceptions.IndexingException;
import org.dizitart.no2.exceptions.InvalidIdException;
import org.dizitart.no2.exceptions.NotIdentifiableException;
import org.dizitart.no2.mapper.NitriteMapper;
import org.dizitart.no2.objects.Id;
import org.dizitart.no2.objects.Index;
import org.dizitart.no2.objects.Indices;
import org.dizitart.no2.objects.InheritIndices;
import org.dizitart.no2.objects.ObjectFilter;
import org.dizitart.no2.objects.filters.ObjectFilters;
import org.dizitart.no2.util.ReflectionUtils;
import org.dizitart.no2.util.StringUtils;
import org.dizitart.no2.util.ValidationUtils;
import org.objenesis.Objenesis;
import org.objenesis.ObjenesisStd;
import org.objenesis.instantiator.ObjectInstantiator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ObjectUtils {
    private static final Logger log = LoggerFactory.getLogger(ObjectUtils.class);
    private static Map<String, ObjectInstantiator> constructorCache = new HashMap<String, ObjectInstantiator>();
    private static Objenesis objenesis = new ObjenesisStd();

    public static <T> String findObjectStoreName(Class<T> type) {
        ValidationUtils.notNull(type, ErrorMessage.errorMessage("type can not be null", 1029));
        return type.getName();
    }

    public static <T> String findObjectStoreName(String key, Class<T> type) {
        ValidationUtils.notNull(key, ErrorMessage.errorMessage("key can not be null", 1084));
        ValidationUtils.notEmpty(key, ErrorMessage.errorMessage("key can not be empty", 1085));
        ValidationUtils.notNull(type, ErrorMessage.errorMessage("type can not be null", 1029));
        return type.getName() + "+" + key;
    }

    public static <T> Set<Index> extractIndices(NitriteMapper nitriteMapper, Class<T> type) {
        List<Index> indexList;
        List<Indices> indicesList;
        ValidationUtils.notNull(type, ErrorMessage.errorMessage("type can not be null", 1030));
        if (type.isAnnotationPresent(InheritIndices.class)) {
            indicesList = ReflectionUtils.findAnnotations(Indices.class, type);
        } else {
            indicesList = new ArrayList<Indices>();
            Indices indices = type.getAnnotation(Indices.class);
            if (indices != null) {
                indicesList.add(indices);
            }
        }
        LinkedHashSet<Index> indexSet = new LinkedHashSet<Index>();
        if (indicesList != null) {
            for (Indices indices : indicesList) {
                Index[] indexList2 = indices.value();
                ObjectUtils.populateIndex(nitriteMapper, type, Arrays.asList(indexList2), indexSet);
            }
        }
        if (type.isAnnotationPresent(InheritIndices.class)) {
            indexList = ReflectionUtils.findAnnotations(Index.class, type);
        } else {
            indexList = new ArrayList<Index>();
            Index index = type.getAnnotation(Index.class);
            if (index != null) {
                indexList.add(index);
            }
        }
        if (indexList != null) {
            ObjectUtils.populateIndex(nitriteMapper, type, indexList, indexSet);
        }
        return indexSet;
    }

    public static <T> Field getIdField(NitriteMapper nitriteMapper, Class<T> type) {
        List<Field> fields = type.isAnnotationPresent(InheritIndices.class) ? ReflectionUtils.getFieldsUpto(type, Object.class) : Arrays.asList(type.getDeclaredFields());
        boolean alreadyIdFound = false;
        Field idField = null;
        for (Field field : fields) {
            if (!field.isAnnotationPresent(Id.class)) continue;
            ValidationUtils.validateObjectIndexField(nitriteMapper, field.getType(), field.getName());
            if (alreadyIdFound) {
                throw new NotIdentifiableException(ErrorMessage.OBJ_MULTIPLE_ID_FOUND);
            }
            alreadyIdFound = true;
            idField = field;
        }
        return idField;
    }

    public static ObjectFilter createUniqueFilter(Object object, Field idField) {
        idField.setAccessible(true);
        try {
            Object value = idField.get(object);
            if (value == null) {
                throw new InvalidIdException(ErrorMessage.ID_FILTER_VALUE_CAN_NOT_BE_NULL);
            }
            return ObjectFilters.eq(idField.getName(), value);
        }
        catch (IllegalAccessException iae) {
            throw new InvalidIdException(ErrorMessage.ID_FIELD_IS_NOT_ACCESSIBLE);
        }
    }

    public static boolean isObjectStore(String collectionName) {
        try {
            if (StringUtils.isNullOrEmpty(collectionName)) {
                return false;
            }
            Class.forName(collectionName);
            return true;
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            return ObjectUtils.isKeyedObjectStore(collectionName);
        }
    }

    public static boolean isKeyedObjectStore(String collectionName) {
        try {
            if (StringUtils.isNullOrEmpty(collectionName)) {
                return false;
            }
            if (!collectionName.contains("+")) {
                return false;
            }
            String[] split = collectionName.split("\\+");
            if (split.length != 2) {
                return false;
            }
            String storeName = split[0];
            Class.forName(storeName);
            return true;
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            return false;
        }
    }

    public static <T> T newInstance(Class<T> type) {
        try {
            String clazz = type.getName();
            ObjectInstantiator instantiator = constructorCache.get(clazz);
            if (instantiator == null) {
                instantiator = objenesis.getInstantiatorOf(type);
                constructorCache.put(clazz, instantiator);
            }
            return (T)instantiator.newInstance();
        }
        catch (Exception e) {
            log.error("Error while creating instance of " + type.getName(), (Throwable)e);
            return null;
        }
    }

    public static <T> Document toDocument(T object, NitriteMapper nitriteMapper, Field idField, boolean update) {
        Document document = nitriteMapper.asDocument(object);
        if (idField != null) {
            Object idValue;
            if (idField.getType() == NitriteId.class) {
                try {
                    idField.setAccessible(true);
                    if (idField.get(object) == null) {
                        NitriteId id = document.getId();
                        idField.set(object, id);
                        document.put(idField.getName(), (Object)id.getIdValue());
                    } else if (!update) {
                        throw new InvalidIdException(ErrorMessage.AUTO_ID_ALREADY_SET);
                    }
                }
                catch (IllegalAccessException iae) {
                    throw new InvalidIdException(ErrorMessage.CANNOT_ACCESS_AUTO_ID);
                }
            }
            if ((idValue = document.get(idField.getName())) == null) {
                throw new InvalidIdException(ErrorMessage.ID_CAN_NOT_BE_NULL);
            }
            if (idValue instanceof String && StringUtils.isNullOrEmpty((String)idValue)) {
                throw new InvalidIdException(ErrorMessage.ID_VALUE_CAN_NOT_BE_EMPTY_STRING);
            }
        }
        return document;
    }

    private static <T> void populateIndex(NitriteMapper nitriteMapper, Class<T> type, List<Index> indexList, Set<Index> indexSet) {
        for (Index index : indexList) {
            String name = index.value();
            Field field = ReflectionUtils.getField(type, name, true);
            if (field != null) {
                ValidationUtils.validateObjectIndexField(nitriteMapper, field.getType(), field.getName());
                indexSet.add(index);
                continue;
            }
            throw new IndexingException(ErrorMessage.errorMessage("field " + name + " does not exists for type " + type.getName(), 5013));
        }
    }

    private ObjectUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

